; -*- Scheme -*-
;
; $Id: char-set-26.scm,v 1.1 1998/03/16 07:57:58 foner Exp $

;+doc
; procedure: char-set:intersection!
; arguments: a b
; signature: char-set x char-set -> unspecified
;
; Modifies A such that it contains the intersection of the sets A and B.
;-doc

(define char-set:intersection!
  (lambda (a b)
    (let loop ((i (- char-set::vector-size 1)))
      (if (not (zero? i))
	  (begin
	    (if (char-set:member? b (char-set::at a i))
		(begin (vector-set! a i #t) (char-set::1+size! a)))
	    (loop (- i 1)))))))

; eof
