; -*- Scheme -*-
;
; $Id: pathname04.scm,v 1.1 1998/03/16 07:59:05 foner Exp $
;
;------------
;
; Merge two PATHNAMEs
;
;------------

(require 'pathname:host)
(require 'pathname:device)
(require 'pathname:directory)
(require 'pathname:name)
(require 'pathname:type)
(require 'pathname:version)

;------------

;+doc
; procedure: pathname:merge
; arguments: a b
; signature: pathname x pathname -> pathname
; 
; Merges the two pathnames A and B.  If an element is defined in both
; A and B, then the value in A takes precedence.
;-doc

(define pathname:merge
  (lambda (a b)
    (pathname:make
     (or (pathname:host a)      (pathname:host b))
     (or (pathname:device a)    (pathname:device b))
     (or (pathname:directory a) (pathname:directory b))
     (or (pathname:name a)      (pathname:name b))
     (or (pathname:type a)      (pathname:type b))
     (or (pathname:version a)   (pathname:version b)))))

; eof
