; -*- Scheme -*-
;
; $Id: pathname07.scm,v 1.1 1998/03/16 07:59:07 foner Exp $
;
;------------

(require 'pathname:directory)
(require 'pathname:name)
(require 'pathname:type)
(require 'unix:pathname:directory->string)

;------------

;+doc
; procedure: unix:pathname->string
; arguments: pathname
; signature: pathname -> string
;
; Converts PATHNAME into a UNIX filename.  The following are some
; examples, where UP->S means UNIX:PATHNAME->STRING and S->UP means
; STRING->UNIX:PATHNAME.
;
; > (up->s (s->up "/usr/me/scm/pathname07.scm"))
; "/usr/me/scm/pathname07.scm"
;
; > (up->s (s->up "usr/me/scm/pathname07.scm"))
; "usr/me/scm/pathname07.scm"
;
; > (up->s (s->up "/usr/../me/scm/pathname07.scm"))
; "/usr/../me/scm/pathname07.scm"
;
; The ".." portion could be folded away in the transformation, but it
; currently isn't, however, if a single "." is :-
;
; > (up->s (s->up "/usr/./me/scm/pathname07.scm"))
; "/usr/me/scm/pathname07.scm"
;
; or even multiple ones :-
;
; > (up->s (s->up "/usr/./././me/scm/pathname07.scm"))
; "/usr/me/scm/pathname07.scm"
;
; As are multiple "/" with out any intervening characters :-
;
; > (up->s (s->up "/usr////me/scm/pathname07.scm"))
; "/usr/me/scm/pathname07.scm"
;
;-doc

(define unix:pathname->string
  (lambda (p)
    (let ((r ""))
      (let ((d (pathname:directory p)))
	(if d (set! r (string-append r (unix:pathname:directory->string d)))))
      (let ((n (pathname:name p)))
	(if n (set! r (string-append r n))))
      (let ((t (pathname:type p)))
	(if t (set! r (string-append r (string-append "." t)))))
      r)))

; The ugly side-effecting code is to avoid calling STRING-APPEND when
; it is known that the string is "".

; eof
