; -*- Scheme -*-
;
; $Id: string38.scm,v 1.1 1998/03/16 07:59:52 foner Exp $

(require 'char-set:member?)

;+doc
; procedure: substring:trim-left-pos-with-chars
; arguments: source start end chars
; signature: string x int x int x char-set -> int
; pre:       (<= 0 start end (string-length source))
;
; Returns the position of the first character in SOURCE starting at
; START (inclusive) and ending at END (exclusive) which is not
; in CHARS.
;
; > (substring:trim-left-pos-with-chars "  some " 0 7 char-set:whitespace)
; 2
;
; > (substring:trim-left-pos-with-chars "some chars" 0 10 char-set:lower-case)
; 4
;-doc

(define substring:trim-left-pos-with-chars
  (lambda (source start end chars)
    (let loop ((p start))
      (if (and (< p end) (char-set:member? chars (string-ref source p)))
	  (loop (+ 1 p))
	  p))))

;-------------

;+doc
; procedure: substring:trim-left-with-chars
; arguments: source start end chars
; signature: string x int x int x char-set -> string
; pre:       (<= 0 start end (string-length source))
;
; Returns a string consisting of SOURCE between START (inclusive) and
; END (exclusive) with any characters in CHARS stripped of the left side. 
;
; > (substring:trim-left-with-chars "  some characters " 0 18 char-set:whitespace)
; "some characters "
;
; > (substring:trim-left-with-chars "some characters" 0 15 char-set:lower-case)
; " characters"
;-doc

(define substring:trim-left-with-chars
  (lambda (s ss se cs)
    (substring s (substring:trim-left-pos-with-chars s ss se cs) se)))

;------------

;+doc
; procedure: string:trim-left-with-chars
; arguments: source chars
; signature: string x char-set -> string
;
; Returns a string consisting of SOURCE with any characters in CHARS
; stripped of the left side.
;
; > (string:trim-left-with-chars "  some characters " char-set:whitespace)
; "some characters "
;
; > (string:trim-left-with-chars "some characters" char-set:lower-case)
; " characters"
;-doc

(define string:trim-left-with-chars
  (lambda (s cs)
    (let ((sl (string-length s)))
      (if (zero? sl)
	  ""
	  (substring:trim-left-with-chars s 0 sl cs)))))

; eof
