; -*- Scheme -*-
;
; $Id: string47.scm,v 1.1 1998/03/16 07:59:57 foner Exp $

;+doc
; procedure: substring:trim-left-by-proc-pos
; arguments: string star end proc
; signature: string x int x int x (char -> bool) -> int
; pre:       (and (<= 0 start) (< start end) (<= end (string-length string)))
;
; Return the ...
;-doc

(define substring:trim-left-by-proc-pos
  (lambda (s ss se p)
    (let loop ((i ss))
	(cond ((= i se) i)
	      ((p (string-ref s i)) (loop (+ i 1)))
	      (else i)))))

;-------------

;+doc
; procedure: string:trim-left-by-proc-pos
; arguments: string proc
; signature: string x (char -> bool) -> int
;
; Return the ...
;-doc

(define string:trim-left-by-proc-pos
  (lambda (s p)
    (substring:trim-left-by-proc-pos s 0 (string-length s) p)))

;-------------

;+doc
; procedure: string:trim-left-by-proc
; arguments: string proc
; signature: string x (char -> bool) -> string
; 
; Trims characters off the left of STRING using PROC, which should
; return #t for each character that needs to be removed, and returns
; the resulting string
;
; Examples:
;
; > (string:trim-left-by-proc "ABCDefghIJKLmnop" char-upper-case?)
; "efghIJKLmnop"
;
; Strip lower case characters.
;
; > (string:trim-left-by-proc "" char-lower-case?)
; ""
; 
; If the string is empty, the procedure does nothing.
;
; > (string:trim-left-by-proc "ABCDefghIJKLmnop" char-whitespace?)
; "ABCDefghIJKLmnop"
;
; Returns a copy of the string if there are no characters stripped.
;-doc

(define string:trim-left-by-proc
  (lambda (s p)
    (let ((sl (string-length s)))
      (substring s (substring:trim-left-by-proc-pos s 0 sl p) sl))))

; eof
