;;;; Yenta counters themselves.

(yreq "Logging/counter-tools")

;;;; Operations.
(def-yenta-counter *ctr:startups*	; ok
  "Startups"
  "Number of startups of this Yenta.")

(def-yenta-counter *ctr:shutdowns*	; ok
  "Shutdowns"
  "Number of shutdowns of this Yenta.")

(def-yenta-counter *ctr:uptime-minutes*	; ok
  "Uptime in minutes"
  "Number of minutes this Yenta has been in operation.")

(def-yenta-counter *ctr:fatal-errors*	; ok
  "Fatal errors"
  "Number of fatal errors this Yenta has experienced.")

(def-yenta-counter *ctr:scheduler-caught-errors* ; ok
  "Scheduler-caught errors"
  "Number of errors caught by the scheduler.")

(def-yenta-counter *ctr:log-count*	; ok
  "Number of log messages sent"
  "Keeps track of the number of log messages sent to the statistics logging server.")

(def-yenta-counter *ctr:logging-errors*	; ok
  "Statistics-logging errors"
  "Number of errors this Yenta has had while logging statistics.")

(def-yenta-counter *ctr:bug-reports*	; NOT SET!  [We don't currently have any way to submit bug reports automatically; just backtraces.]
  "Bug reports"
  "Number of bug reports submitted from this Yenta.")

;;;; User Interface
(def-yenta-counter *ctr:pages-fetched*	; ok
  "Pages fetched"
  "Number of HTML pages fetched by this Yenta.")

; (def-yenta-counter *ctr:pages-pushed*
;   "Pages pushed"
;   "Number of HTML pages pushed by this Yenta.")

(def-yenta-counter *ctr:docs-fetched*	; ok
  "Documentation pages fetched"
  "Number of documentation pages fetched by this Yenta.")

;;; %%% Also include any individual pages desired...

;;;; interYenta communication.

(def-yenta-counter *ctr:conns-initiated* ; done
  "Connections initiated"
  "Number of interYenta connections this Yenta has initiated.")

(def-yenta-counter *ctr:conns-served*	; done
  "Connections served"
  "Number of interYenta connections this Yenta has answered.")

(def-yenta-counter *ctr:opcodes-sent*	; done
  "Opcodes sent"
  "Number of opcodes this Yenta has sent to other Yentas.")

(def-yenta-counter *ctr:opcodes-received* ; done
  "Opcodes received"
  "Number of opcodes this Yenta has received from other Yentas.")

(def-yenta-counter *ctr:network-errors*	; done
  "Network errors"
  "Number of network errors this Yenta has encountered during interYenta communication; this is the \":nak malformed\" response.")

(def-yenta-counter *ctr:bytes-sent*	; done
  "Bytes sent"
  "Total number of bytes this Yenta has sent to other Yentas.")

(def-yenta-counter *ctr:bytes-received*	; done
  "Bytes received"
  "Total number of bytes this Yenta has received from other Yentas.")

(def-yenta-counter *ctr:auth-failures*	; done
  "Authentication failures"
  "Number of times this Yenta has rejected another Yenta's supposed ID.")

(def-yenta-counter *ctr:random-requests* ; NOT SET!  [What exactly is this supposed to mean?]
  "Yenta Requests"
  "Number of times Yenta asks for other Yentas to communicate with.")

;;;; Bootstrap.

;;; Transmitters.
(def-yenta-counter *ctr:boot-broadcast-pings-sent* ; ok
  "Bootstrap broadcast pings sent"
  "Number of broadcast pings this Yenta has sent while bootstrapping.")

(def-yenta-counter *ctr:boot-central-pings-sent* ; ok
  "Bootstrap central-server pings sent"
  "Number of pings this Yenta has sent to the central server while bootstrapping.")

(def-yenta-counter *ctr:boot-registrations-sent* ; ok
  "Bootstrap central-server registrations sent"
  "Number of registrations this Yenta has sent to the central server.")

(def-yenta-counter *ctr:boot-pongs-sent* ; ok
  "Bootstrap pongs sent"
  "Number of responses to pings sent.  This means different things in customer Yentas vs the central server.")

;;; Receivers.
(def-yenta-counter *ctr:boot-udp-received* ; ok
  "Bootstrap UDP packets received"
  "Number of UDP packets this Yenta has received, whether good or not.")

(def-yenta-counter *ctr:boot-dropped-own* ; ok
  "Bootstrap UDP packets received that appear to have come from ourselves"
  "Number of UDP packets received that appear to have come from ourselves.  Might be broadcast; might be timesharing case.")

(def-yenta-counter *ctr:boot-udp-bad-opcode* ; ok
  "Bootstrap UDP invalid-opcode packets received"
  "Number of invalid-opcode UDP packets this Yenta has received.")

(def-yenta-counter *ctr:boot-udp-bad-version* ; ok
  "Bootstrap UDP unrecognized-version packets received"
  "Number of unrecognized-version UDP packets this Yenta has received.")

(def-yenta-counter *ctr:boot-udp-other-invalid*	; ok
  "Bootstrap UDP invalid packets received"
  "Number of invalid UDP packets this Yenta has received, not including opcode/protocol problems.")

(def-yenta-counter *ctr:boot-misdirected-registrations*	; ok
  "Bootstrap UDP misdirected registrations received"
  "Number of registrations this Yenta has received, when it's not the central server at all.")

(def-yenta-counter *ctr:boot-registrations-received* ; ok
  "Bootstrap registrations received"
  "Number of registrations received.  Only the central server tracks this.")

(def-yenta-counter *ctr:boot-pongs-received* ; ok
  "Bootstrap pongs received"
  "Number of pongs received.  Only noticed by Yentas which are currently awaiting responses to pings.")

;;;; Preclustering.

(def-yenta-counter *ctr:bytes-scanned*	; don't have this yet-- no byte info gets to Scheme
  "Bytes scanned"
  "Number of bytes of user files this Yenta has read in forming granules during preclustering.")

(def-yenta-counter *ctr:docs-scanned*	; done
  "Documents scanned"
  "Number of documents (user files) this Yenta has read in forming granules during preclustering.")

(def-yenta-counter *ctr:rescans*	; done
  "Rescans"
  "Number of rescans of user documents this Yenta has performed.")

(def-yenta-counter *ctr:reclusters*	; done
  "Reclusters"
  "Number of reclusters this Yenta has performed in preclustering.")

;;;; Matchmaking.

(def-yenta-counter *ctr:yentas-encountered* ; NOT SET!  [Er, this is -almost- conns-initiated and conns-served, right?  What about :reverse?]
  "Yentas encountered"
  "Number of other Yentas this Yenta has encountered, including repeats.")

(def-yenta-counter *ctr:clusters-joined* ; done
  "Clusters joined"
  "Number of clusters this Yenta has joined.")

(def-yenta-counter *ctr:clusters-left*	; %%% Doesn't happen yet.
  "Clusters left"
  "Number of clusters this Yenta has left.")

(def-yenta-counter *ctr:intros-i-requested* ; ok.
  "Introductions I requested"
  "Number of introductions this Yenta has requested.")

(def-yenta-counter *ctr:intros-i-answered* ; NOT SET!  [No such action in this release of Yenta.]
  "Introductions I answered"
  "Number of introductions this Yenta has responded to.")

(def-yenta-counter *ctr:intros-i-refused* ; NOT SET!  [No such action in this release of Yenta.]
  "Introductions I refused"
  "Number of introductions this Yenta has refused.")

(def-yenta-counter *ctr:intros-requested-of-me*	; NOT SET!  [No such action in this release of Yenta.]
  "Introductions requested of me"
  "Number of introductions that have been requested of Yenta.")

(def-yenta-counter *ctr:intros-answered-me* ; NOT SET!  [No such action in this release of Yenta.]
  "Introductions answered"
  "Number of introductions this Yenta has requested that were answered.")

(def-yenta-counter *ctr:intros-refused-me* ; NOT SET!  [No such action in this release of Yenta.]
  "Introductions refused me"
  "Number of introductions this Yenta has requested that were refused.")

;;; %%% NOTE: byte length counters aren't currently supported:  they require knowing
;;; %%% how long messages (e.g.) are, which we don't have a good hook for.

(def-yenta-counter *ctr:ind-messages-sent* ; done
  "Individual messages sent"
  "Number of messages this Yenta has sent to other individual Yentas.") ;done

;(def-yenta-counter *ctr:ind-bytes-sent*
;  "Individual message bytes sent"
;  "Number of bytes this Yenta has sent in messages to other individual Yentas.")

(def-yenta-counter *ctr:ind-messages-received* ; done
  "Individual messages received"
  "Number of individual messages this Yenta has received from other Yentas.")

;(def-yenta-counter *ctr:ind-bytes-received*
;  "Individual message bytes received"
;  "Number of bytes this Yenta has received in individual messages from other Yentas.")

(def-yenta-counter *ctr:cluster-messages-sent* ; done
  "Cluster messages sent"
  "Number of messages this Yenta has sent to Yenta clusters.")

;(def-yenta-counter *ctr:cluster-bytes-sent*
;  "Cluster message bytes sent"
;  "Number of bytes this Yenta has sent in messages to clusters.")

(def-yenta-counter *ctr:cluster-messages-received* ; done
  "Cluster messages received"
  "Number of cluster messages this Yenta has received.")

;(def-yenta-counter *ctr:cluster-bytes-received*
;  "Cluster message bytes received"
; "Number of bytes this Yenta has received in cluster messages.")

;;;; Attestations.

(def-yenta-counter *ctr:atts-made*	; done
  "Attestions made"
  "Number of attestations the user has made.")

(def-yenta-counter *ctr:atts-fetched*	; done
  "Attestations-fetched"
  "Number of times this Yenta's attestations were requested.")

(def-yenta-counter *ctr:sigs-received*	; done
  "Signatures-received"
  "Number of signatures this Yenta has received on its attestations.")

(def-yenta-counter *ctr:sigs-made*	; done
  "Signatures made"
  "Number of signatures this Yenta has made on other Yentas' attestations.")

(def-yenta-counter *ctr:sigs-verified*	; done
  "Signatures verified"
  "Number of signatures on attestations this Yenta has verified.")

(def-yenta-counter *ctr:atts-removed*	; done
  "Attestations removed"
  "Number of attestations the user has removed.")

;;;; Runtime counter.

;;; One counter -- "minutes-tick" -- gets incremented via a scheduler task.
;;; Add this task now.

(define (ctr:count-minutes)
  (scheduler:add-periodic-task!
    "Count minutes in operation" 3	; Priority.
    60					; Tick once a minute.
    (lambda () 
      (inc! *ctr:uptime-minutes*))))

;;; End of file.
