(define (authenticate:check-passphrase)
;  (format-debug 8 "~&authenticate:check-passphrase in authenticate-response.scm:~&   ~
;                   *hashed-passphrase* = ~S, *vars:successfully-loaded-everything* = ~S, *local-yenta-pub-key* = ~S~&"
;		*hashed-passphrase* *vars:successfully-loaded-everything* *local-yenta-pub-key*)
  (let ((passphrase (ui:form-datum "passphrase")))
    (cond (passphrase			; We got here from a page that asks about passphrases.
	   (passphrase:set-passphrase-unconditionally passphrase #f) ; Must set this so we can attempt decryption!
	   (let ((result (vars:try-loading-encrypted)))
	     (case (car result)
	       ((ok)			; We're now authenticated.
		(ui:note-session-authenticity #t) ; This SSL session is now valid.
		(set! *ui:startup-state* 'crypto-read) ; We've read the crypto state.
		(wb:start-yenta-completely) ; Actually start all the rest of Yenta.
		(wb:start-interyenta-tasks) ; Start the networking, too.
		(list
		 (format nil "<h1>Yenta authenticated</h1>~&~
                              <b>You have been authenticated.</b><br><br>~&")
		 ;; %%% Until I figure out how I broke the button (the next thing the user sees
		 ;; %%% is the last format in this function), don't even offer the choice.  We
		 ;; %%% do this via the "(or #t ...) immediately below.  --- Foner.
		 (cond ((or #t		; %%% Turn off the button until it's fixed.
			    (equal? (ui:form-datum "original-url")
				    "/"))
			"<a href = \"/\"><b>Proceed to the front page.</b></a>")
		       (t
			(list
			 "<form method = "
			 (ui:form-datum "original-method")
			 " action = \""
			 (ui:form-datum "original-url")
			 ;; %%% Other data...
			 (format nil "\">~&~
                                      <b>You may <input type = \"submit\" value = \"continue\"> with your previous request,~&~
                                      </form>~&~
                                      or begin from the <a href = \"/\">front page</a>.<b><p>"))))))
	       ((mismatch)		; Bad passphrase.
		(ui:note-session-authenticity #f)
		(format nil "<h1>Passphrase incorrect</h1>~&~
                             <b>The passphrase you supplied is not correct.<br><br>~&~
                             Please <a href = \"/\">try again</a>.</b>~&"))
	       ((#f)
		(format-debug 0 "~&authenticate:check-passphrase (#f . ~S)~&" (cdr result))
		(cond ((eq (cdr result) 'file-not-found) ; No vars.scm.crypt, so we might as well be virginal...
		       (set! *ui:startup-state* 'brand-new-yenta) ; Shouldn't have gotten here, but get the user to register again...
		       (ui:front-page-contents))
		      (t
		       "authenticate:check-passphrase in authenticate-response.scm.  I have no idea what to do here."))) ; %%%
	       (else			; Anything else is a fatal error.  Emit it to the browser.
		(format nil "<b>~A<p>Your only option at this point is to <a href = \"quit.html\">quit</a>.</b>"
			(cdr result) "</b>")))))
	  (t				; We didn't actually get here from a page that asks about passphrases.
	   (cond (*current-authenticated-session* ; We're already authenticated, so just punt.
		  (format nil "<b>You must have gotten to this page by typing its URL in manually,~&~
                               or by following a bookmark you dropped.  In any event, you are~&~
                               already authenticated.  Please choose another link, such as the~&~
                               <a href = \"/\">main page</a>.</b>~&"))
		 (t			; We're not already authenticated.
		  (format nil "<b>You must have gotten to this page by typing its URL in manually,~&~
                               or by following a bookmark you dropped.  In any event, you have~&~
                               not already authenticated.  Please <a href = \"/\">authenticate</a> first.</b>~&")))))))
