(define (interests-contact:describe)
  (let* ((index (string->number ui:index))
	 (user-desc (vector-ref (list-ref *interests:information* index) 0)))
    (if (> (string-length user-desc) 0)
	user-desc
	(compare:show-document (compare:centroid index) 5))))

(define (interests-contact:contact-list)
  (ui:pretty-html-exp-list
   (map (lambda (item)
	  (let ((id (if (pair? item) (car item) item)))
	    (list
	     "<a href = \"identity.html?"
	     (ui:bytes->hex id)
	     "\">"
	     (identity:description id)
	     "</a>"
	     )))
	(list-ref *iy:cluster-cache* (string->number ui:index)))))

