;;; %%% This is obsolete, but kept here an example.
;;; It was called from a web page via {(interests:instruction-check)}.
(define (interests:instruction-check)
  (if (and ui:index
	   (equal? ui:index "instructions")) ; Just in case
"<h1>Yenta's interest managing methods</h1>

<h2>Interests</h2>

An interest is a topic you either talk about frequently, or would like to
talk about. It is referred to by a title for your convenience, although it
is actually much more detailed.<p>

Not all interests are things you wish to talk about. For example, if you
constantly have lunch meetings, you probably do not want to discuss lunch
meetings with other people. You may want to be introduced to people who talk
about the same topics at their lunch meetings, however.<p>

For this purpose, Yenta will find the fact that you talk about lunch
meetings, and when you express uninterest, will ignore information about
meetings when examining documents. This will take a message that says you're
going to have a lunch meeting about Scheme programming, and see the topic
\"Scheme programming\", and ignore the \"lunch meeting\" aspect. This behavior
is used by unsetting the \"Relevant\" box for the interest.<p>

<h2>Specifying interests</h2>

The easiest way to specify what you're interesting in is to give Yenta
access to your email. To do this, set the \"Email path\" preference below to
the location that your email is in. Check the \"Find interests now\" box, and
submit the form. Yenta will begin examining your email, and notify you when
it's done. You can also specify how long it should wait before looking again.<p>

However, this method may not work for you; often you email does not
reflect what you want to talk about, because you haven't found anyone to
talk about it with yet. For this, you need to use the \"describe interest\"
link below.<p>"

"<a href = \"interests.html?instructions\">Instructions</a><p>"))

(define *interests:saved-oncedir* "")	; For refreshing the slot on the form.
(define *interests:saved-interests* "")	; Ditto.

(define (interests:initialize-form-slots) ; Initialize some reasonable defaults locations.
  ;; Oops.  Unless we have additional buttons or something, we -can't- default these after all.
  ;; Doing so means that, unless the user manually cleared them out, he'd start both the oncedir
  ;; action and the interests action just by clicking the button, which is probably not what
  ;; we want.  The reason this worked in index.scm is 'cause we -demanded- that that action be
  ;; taken, -and- 'cause we only had one slot, not two.
; (unless (and *interests:saved-oncedir*
;	       (not (null? *interests:saved-oncedir*)))
;   (set! *interests:saved-oncedir* (getenv "HOME")))
; (unless (and *interests:saved-interests*
;	       (not (null? *interests:saved-interests*)))
;   (set! *interests:saved-interests* (getenv "HOME")))
  "")

(define (interests:mod-form)		; %%% This should do more error-checking of nonexistent directories, etc.
  (cond ((ui:from-form?)
	 (format-debug 0 "~%interests:mod-form is running...~&")
	 (let ((form-search-freq (ui:form-datum "search-freq"))	; From interests-directories.html.
	       (form-searchdir (ui:form-datum "searchdir"))     ; From interests-directories.html.
	       (form-search-now (ui:form-datum "search-now"))   ; From interests-directories.html.
	       (form-oncedir (ui:form-datum "oncedir"))	        ; From interests-oneshot.html.
	       (form-interests (ui:form-datum "interests"))     ; From interests-oneshot.html.
	       (form-start-f-i (ui:form-datum "start-f-i"))     ; From interests:undone-note (this file).
	       (form-change-interests (ui:form-datum "change-interests"))) ; From interests:maybe-make-interest-changes-button (this file).
	   (format-debug 0 "~&~A = ~A~&~A = ~A~&~A = ~A~&~A = ~A~&~A = ~A~&~A = ~A~&"
			 'search-freq form-search-freq
			 'searchdir form-searchdir
			 'search-now form-search-now
			 'oncedir form-oncedir
			 'start-f-i form-start-f-i
			 'interests form-interests)
	   (when form-change-interests	; If we didn't come from this page, there'll be no checkbox data, so we'll think they're all off.  Wrong...
	     (for-each (lambda (index)
			 (let* ((old-int (vector-ref (list-ref *interests:information* index) 2))
				(datum (ui:form-datum (string-append "rel-" (number->string index))))
				(datum-state (if datum #t #f)) ; Force it to be #t or #f, not something weird like "on".
				(changed-state? (not (equal? old-int datum-state))))
;			   (format-debug 0 "~&ui:data = ~S~&" ui:data)
;			   (format-debug 0 "~&OLD = ~S, D = ~S, DS = ~S, changed? = ~S~&"
;					 old-int datum datum-state changed-state?)
			   (when changed-state?
			     (vector-set! (list-ref *interests:information* index) 2 datum-state)
			     (set! *interests:last-changed* (current-time))))
			 (let ((form-title-n (ui:form-datum (string-append "title-" (number->string index)))))
			   (when form-title-n
			     (vector-set! (list-ref *interests:information* index) 0 form-title-n))))
		       (compare:indices)))
	   (when form-search-freq
	     (let ((search-freq (string->number form-search-freq)))
	       (unless (= search-freq *interests:collect-freq*)
		 (set! *interests:collect-freq* search-freq)
		 (interests:reschedule-auto-search))))
	   (append
	    (cond (form-searchdir
		   (let ((searchdir (map expand-dir (ui:textarea->list form-searchdir))))
		     (cond ((or (not (equal? searchdir *interests:search-dirs*))
				form-search-now)
			    (set! *interests:search-dirs* searchdir)
			    (when form-search-now
			      (interests:run-auto-search))
			    (list
			     "<h2>Search directories set</h2>"
			     (if form-search-now
				 "I will now search the directories you indicated, and will remember them to search again later.<p>"
				 "When you ask me to look for new documents, I will search the directories you specified.<p>")))
			   (t '()))))
		  (t '()))
	    (cond ((and form-oncedir
			(not (equal? (expand-dir form-oncedir) "")))
		   (set! *interests:saved-oncedir* form-oncedir) ; Update the form slot, but keep it the way the user typed it.
		   (if (interests:acquire-docs (expand-dir form-oncedir))
		       (list
			"<h2>Immediate search started</h2>
                         I have added " form-oncedir " to my list of directories being searched.<br>
                         <img src = \"news-note.gif\"")
		       (list
			"<h2>Immediate search started</h2>
                         I have begun looking at " form-oncedir "<br>
                         <img src = \"news-note.gif\"")))
		  (t '()))
	    (cond (form-start-f-i
		   (interests:find-interests!)
		   (list "<h2>Interest search started</h2>"
			 "<img src = \"news-note.gif\"> I have begun calculating your interests."))
		  (t '()))
	    (cond ((and form-interests
			(not (equal? (expand-dir form-interests) "")))
		   (set! *interests:saved-interests* form-interests) ; Update the form slot, but keep it the way the user typed it.
		   (do ()
		       ((= 0 (compare:collection-length
			      *interface:provided-interest*)))
		     (compare:remove-document *interface:provided-interest* 0))
		   (compare:acquire-document *interface:provided-interest*
					     (expand-dir form-interests))
		   (case (compare:collection-length 
			  *interface:provided-interest*)
		     ((0) "<h2>Specified interest</h2>
                           The document you specified either does not exist or does not contain any significant words.<p>")
		     ((1) (list "<h2>Specified interest</h2>
                                 Yenta has looked at the document you provided to specify your interest.
                                 These are the words it found which best describe it:<p><i>"
				(ui:literal 
				 (compare:show-document
				  (compare:collection-ref 
				   *interface:provided-interest* 0)
				  10))
				"</i><p>If you are not happy with this
                                 impression of the interest, change the document and try again.  It would probably help to
                                 read the <a href = \"help-specifying-interests.html\">advice</a> about how to specify an
                                 interest in the way that Yenta can best understand.<p>
                                 <a href = \"interest-okay.html\">Interest is accurate</a><hr>"))
		     (else "<h2>Specified interest</h2>
                            The document you specified was either too long or was formatted as a file
                            containing multiple documents (e.g., a mailbox with more than one message).")))
		  (t '())))))
	(t "")))

(define (interests:interest-table-body)
  (set! *ui:interest-new* #f)		; Close the door.
  (cond ((= 0 (compare:database-size))
	 (format nil "<b>I do not know of any of your interests yet. ~&~
                      Please <a href=\"interests-oneshot.html\">scan some files</a> to find some.</b>"))
	(*interests:clustering?*
	 (list
	  "<b>The table of your interests is unavailable while interest-finding is in progress.</b>"))
	(else
	 (append 
	  (list 
	   "<table border = \"1\"><tr><th>Title</th><th>Some related words</th>"
	   "<th>Size</th><th>Contacts</th><th>Relevant?</th>\n")
	  (map
	   (lambda (index)
	     (list
	      (format nil "<tr>~&~
                             <td><input type = \"text\" name = \"title-~A\" value = \"~A\"></td>~&~
                             <td>~A</td>~&~
                             <td>~A</td>~&~
                             <td align = \"center\"><a href = \"interests-contact.html?~A\">~A</a></td>~&~
                             <td align = \"center\"><input type = \"checkbox\" name = \"rel-~A\" ~A></td>~&~
                           </tr>~&"
		      index		; name (title-~A)
		      (vector-ref (list-ref *interests:information* index) 0) ; value
		      (compare:show-document (compare:centroid index) 5) ; table cell
		      (compare:cluster-size index) ; table cell
		      index		; interests-contact.html?~A
		      (vector-ref (list-ref *interests:information* index) 1) ; link name
		      index		; name (rel-~A)
		      (ui:on-off (vector-ref (list-ref *interests:information* index) 2))))) ; "checked" or ""
	   (compare:indices))
	  (list "</table>\n")))))

(define (interests:undone-note)
  (cond ((= (compare:collection-length *interests:undone*) 0)
	 (cond (*interests:alert-about-no-interests?* ; If there aren't any interests at all, the user is already being dunned about it.
		"")
	       (t
		"<b>All the documents you've given me recently fit into some existing interest of yours.</b><p>")))
	(t
	 (format nil "<b>I know about ~A document~:P that I have not put into any of these interests.~&~
                      I am ~:[not~;~] currently working on these.<p>~&~
                      ~:*~:[<input type = \"checkbox\" name = \"start-f-i\"> Start finding interests.~;~]</b>~&"
		 (compare:collection-length *interests:undone*)
		 *interests:clustering?*))))

;;; If there aren't any interests, don't offer to make changes.
;;; This depends on browsers doing the right thing with forms that
;;; don't have any submit buttons at all.  If this is a bad assumption,
;;; we'll have to punt the <form> and </form> tags, too.
(define (interests:maybe-make-interest-changes-button)
  (cond (*interests:alert-about-no-interests?*
	 "")
	(t
	 "<p><input type = \"submit\" value = \"Make changes\" name = \"change-interests\">")))	; The name must match interests:mod-form !

;;; End of file.
