(define (new-message:selections)
  (let ((options (filter (lambda (index)
			   (vector-ref 
			    (list-ref *interests:information* index) 2))
			 (compare:indices))))
    (map (lambda (index)
	   (format nil "<option value = \"~A\">~A</option>"
		   (number->string index)
		   (interests:description index)))
	 options)))

(define (new-message:interest-listbox selections)
  (format nil "<input type = \"hidden\" name = \"seq-num\" value = \"~A\">~&~
               <select name = \"local-topic\">~A</select>"
	  *ui:send-seq-num*
	  selections))

(define (new-message:form)
  (let ((s (new-message:selections)))
    (cond ((not (null? s))
	   (format nil "<form action = \"send-message.html\" method = \"post\">~&~
			<b>Title</b>: <input type = \"text\" name = \"title\">~&~
			<br>~&~
			<b>Message to all contacts for </b>~A~&~
			<br>~&~
			<textarea name = \"body\" cols = \"50\" rows = \"4\">~&~
			</textarea>~&~
			<p>~&~
			<input type = \"submit\" value = \"Send message\">~&~
			</form>~&"
		   (new-message:interest-listbox (join-strings s " "))))
	  (t
	   "<b>[You have no known interests, so you can't compose a message to one.]</b>"))))
