/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

/*
 * Fist_cryptfs mount info - one per mount
 */

#ifndef	_SYS_FS_FIST_CRYPTFS_H
#define	_SYS_FS_FIST_CRYPTFS_H

#include <vm/page.h>
#include <sys/tiuser.h>
#include <blowfish.h>

#define FIST_IOCTL_SET_KEY	(FIST_DBGIOC | 10)

#ifdef	__cplusplus
extern "C" {
#endif

#undef	MAXNAMLEN
#define	MAXNAMLEN	255

  struct fist_crypt_args {
    struct netbuf addr;		/* daemon address */
    char *path;			/* fist_cryptfs mountpoint */
    char *opts;			/* default mount options */
    char *map;			/* name of map */
    int mount_to;		/* time in sec the fs is to remain */
    /* mounted after last reference */
    int rpc_to;			/* timeout for rpc calls */
    int direct;			/* 1 = direct mount */
  };

#ifdef	_KERNEL

#define FIST_HASH_SHIFT  4
#define FIST_HASH_SIZE  (1 << FIST_HASH_SHIFT)
#define FIST_HASH_MASK  (FIST_HASH_SIZE - 1)

  struct fist_crypt_callargs {
    vnode_t *fwc_vp;		/* vnode */
    char *fwc_name;		/* name of path to mount */
    cred_t *fwc_cred;
  };

  typedef struct fist_key{
    int uid;
    BF_KEY key;
    struct fist_key *next;
  } fist_key_t;

  struct fist_cryptinfo {
    struct vfs *fwi_mountvfs;	/* vfs we interpose on */
    struct vnode *fwi_rootvnodep;	/* root vnode */
    int fwi_num_vnodes;		/* # of interposed vnodes */
    /* HT to map hidden_vp to vp */
    fist_bucket_t *fwi_buckets[FIST_HT_SIZE];
    kmutex_t fwi_ht_lock;	/* lock for HT */
    fist_key_t *fwi_user[FIST_HASH_SIZE];
    krwlock_t fwi_user_rwlock;	/* rwlock for user key HT */
  };

  /*
   * The fist_cryptnode is the "inode" for fist_cryptfs.  It contains
   * all the information necessary to handle fist_crypt-matic mounting.
   */
  typedef struct fist_cryptnode {
    vnode_t *fwn_vnodep;	/* interposed vnode pointer */
    u_int fwn_mapcnt;		/* mapped pages counter */
    kmutex_t fwn_lock;		/* lock for private data */
  } fist_cryptnode_t;

  /*
   * Mount flags
   */

#define	MF_MNTPNT		0x001	/* A mountpoint */
#define	MF_INPROG		0x002	/* mount in progress */
#define	MF_WAITING_MOUNT	0x004	/* thread waiting */
#define	MF_WAITING_UMOUNT	0x008
#define	MF_MOUNTED		0x010	/* mount taken place */
#define	MF_UNMOUNTING		0x020	/* unmount in prog */
#define	MF_DONTMOUNT		0x040	/* unmount failed, so don't */
  /* try another mount */
#define	MF_CHECKED		0x080	/* checked by unmount thread */

  /*
   * Convert between vfs/fist_cryptinfo & vnode/fist_cryptnode
   */
#define	fwntovn(ap)	(&((ap)->fwn_vnode))
#define	vntofwn(vp)	((struct fist_cryptnode *) ((vp)->v_data))
#define	vfstofwi(vfsp)	((struct fist_cryptinfo *) ((vfsp)->vfs_data))

  /*
   * Flags for crypt_{en,de}code_filename
   * DO_DOTS means the special entries . and .. should be encoded (for symlink)
   * SKIP_DOTS means they should be preserved intact
   */
#define DO_DOTS   0
#define SKIP_DOTS 1

  extern kmutex_t fist_cryptnode_list_lock;
  extern struct fist_cryptnode *fist_cryptnode_list;
  extern kmutex_t fist_cryptnode_count_lock;
  extern int anode_cnt, makefist_cryptnode_count, freefist_cryptnode_count;

  extern int do_mount(vnode_t *, char *, cred_t *);
  extern int fist_cryptdir_lookup(vnode_t *, char *, vnode_t **, cred_t *);
  extern int fist_crypt_direnter(fist_cryptnode_t *, fist_cryptnode_t *);
  extern void do_unmount(void);
  extern vnode_t *makefist_cryptnode(vtype_t, vfs_t *, cred_t *);
  extern void freefist_cryptnode(fist_cryptnode_t * anp);

  /* for page to kernel virtual memory mapping */
  extern caddr_t ppmapin(page_t * pp, u_int vprot, caddr_t hint);
  extern void ppmapout(caddr_t va);

  extern vnode_t *fist_crypt_interpose(vnode_t * hidden_vp, vfs_t * this_vfsp);
  extern int fist_crypt_decodefilename(vfs_t * vfsp, char *name, int length, char *decoded_name, int *decoded_length, int skip_dots,cred_t *cr);
  extern void fist_crypt_encodefilename(vfs_t * vfsp, char *name, char **encoded_name, int *encoded_length, int skip_dots,cred_t *cr);
  extern int crypt_encode_block(char *func, int line, caddr_t base, int len, const vnode_t *vp,cred_t *cr);
  extern int crypt_decode_block(char *func, int line, caddr_t base, int len, const vnode_t *vp,cred_t *cr);
  extern unsigned char cbc_iv[8];
  extern int isbad(caddr_t base, int len);
  extern BF_KEY * fist_get_userpass(const vfs_t * this_vfsp, cred_t * cr);
  extern void fist_set_userpass(const vfs_t * this_vfsp,unsigned char* key, cred_t * cr);
  extern void fist_free_userpass(const vfs_t * this_vfsp);


#endif				/* _KERNEL */

#ifdef	__cplusplus
}

#endif
#endif				/* _SYS_FS_FIST_CRYPTFS_H */
