#include <sys/types.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */

#include <sys/param.h>
#include <sys/mount.h>
#ifdef HAVE_SYS_MNTENT_H
# include <sys/mntent.h>
#endif /* HAVE_SYS_MNTENT_H */
#include <stdio.h>

int main(int argc, char **argv)
{
  int err = 0;
  char fs_name[100];

  /* validate input */
  if (argc != 4) {
    fprintf(stderr, "Usage: %s [fs_type interposed_dir mount_point]\n",
	    argv[0]);
    exit(1);
  }
  sprintf(fs_name, "fist_%s", argv[1]);

  err = mount(argv[2], argv[3] , MS_FSS, fs_name, 0, 0);
  if (err < 0) {
    perror(argv[0]);
  }
  exit(err);
}
