/*
 *	$Source: /mit/kerberos/src/appl/erlogin/RCS/rldio.c,v $
 *	$Author: steiner $
 *	$Header: rldio.c,v 4.1 87/09/01 16:17:39 steiner Exp $
 */

#ifndef lint
static char *rcsid_rldio_c = "$Header: rldio.c,v 4.1 87/09/01 16:17:39 steiner Exp $";
#endif lint

/*
 * Copyright (c) 1983 Regents of the University of California.
 * Changes Copyright (c) 1987 Massachusetts Institute of Technology.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char sccsid[] = "@(#)rldio.c	5.10 (Berkeley) 3/30/86";
#endif not lint

/*
 * rlogind's i/o support routines. 
 * called only by rlogind, but linked with rlogin.
 * This redundant linking is necessary in order to keep
 * client and server routines together in the modules
 * winoob.c and envoob.c; this togetherness aids legibility.
 */

#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include "fifo.h"

extern FILE	*dbg;
extern int	errno;
char *		malloc();

extern unsigned char	winsiz_req;

/*
 * globals for oob-handlers' use
 */
struct fifo	netfbuf;	/* server's oobs' sock-to-pty buffer */
int		netf;		/* server's socket */
int		pty;		/* server's pty */
int		ext_rem;	/* client's socket */

flush_to_oob_mark(f, p) int f, p; {
/* This is called by rlogind's out-of-band handlers. see window.c and env.c .
 *     if the socket is at an out-of-band mark, we can return immediately.
 * otherwise, we have to pump the socket-to-pty flow until we reach the mark:
 * 1) empty the socket's fifo onto the pty;
 * 2) read from the socket, refilling its fifo;
 * 3) check again to see if we're at the oob mark.
 * Note that we use blocking i/o, unlike the protocol routine.
 */
	int atmark = 0;

	DBG_FPRINTF((dbg, ">>flush_to_oob_mark\n"));
	for (;;) {
		if (0 > ioctl(netf, SIOCATMARK, &atmark))
			fatalperror(netf, "ioctl", errno);
		if (atmark) break;

		if (0 == netfbuf.cc && fillbuf(f, &netfbuf) == READ_FAILED)
			giveup();

		DBG_FPRINTF((dbg, "ftom: fcc= %d\n", netfbuf.cc));

		if (netfbuf.cc > 0) drainbuf(&netfbuf, p);
		else giveup();
	}
	DBG_FPRINTF((dbg, "<<ftom: fcc = %d atmark= %x\n", netfbuf.cc, atmark));
}

giveup() {
/*     Rlogind will catch SIGQUIT and cleanup. Not calling cleanup() directly
 * means we don't have to be linked with it, nor with its several subroutines.
 */
	kill(getpid(), SIGQUIT);
}

/*
 * fifo buffer abstraction, for copying sock-to-pty or vice-versa.
 * not used by the client-side code.
 */

int initbuf(bp, size) struct fifo *bp; int size; {
	bp->area = malloc(size);
	bp->next = bp->area;
	bp->size = size;
	bp->cc = 0;
}
int fillbuf(in_fd, bp) int in_fd; struct fifo *bp; {
	/* load the empty fifo buffer */
	int cc;
	bp->next = bp->area;
	cc = read(in_fd, bp->area, bp->size);
	if (cc > 0) bp->cc = cc;
	else if (cc < 0 && errno == EWOULDBLOCK) bp->cc = 0;
	else if (cc <= 0) return(READ_FAILED);
	return(0);
}
int drainbuf(bp, out_fd) struct fifo *bp; int out_fd; {
	/* empty as much as possible of the fifo buffer */
	int cc;
	cc = write(out_fd, bp->next, bp->cc);
	if (cc > 0) {
		bp->cc   -= cc;
		bp->next += cc;
	}
	else if (cc < 0 && errno == EWOULDBLOCK) return (WRITE_FAILED);
	return(0);
}
unsigned
char pty_stat(bp, out_fd) struct fifo *bp; int out_fd; {
	/* check the buffer's first word for the pty's packet-mode
	 * control-status byte, & pass it along to the rlogin client process.
	 * if there is none, advance the buffer to discard the control byte.
	 * this should be only be called for the pty. see pty(4) man page.
	 */
	unsigned char cntl = bp->area[0];

	if (1 != bp->cc) return('\0');
	if (cntl & (TIOCPKT_FLUSHWRITE | TIOCPKT_NOSTOP | TIOCPKT_DOSTOP))
		send_oob(out_fd, cntl);

	else { /* skip over the control word */
		bp->next++; bp->cc--;
		if (bp->cc == 0) bp->next = bp->area;
	}
	return(cntl);
}
/*
 * end of fifo abstraction
 */

send_oob(fd, oobchar) int fd; unsigned char oobchar; {
/* rlogin may fail to answer rlogind's first request for window-sizes.
 * if window-sizes haven't arrived yet, ask for them again, whenever
 * rlogind sends out-of-band data down to rlogin.
 */
	int cc;
		
	DBG_FPRINTF((dbg, ">>send_oob: oobchar = %x, winsiz_req = %x\n",
		oobchar, winsiz_req));
	oobchar |= winsiz_req;
	cc = send(fd, &oobchar, 1, MSG_OOB);

	DBG_FPRINTF((dbg, "<<send_oob: cc = %d errno = %d\n", cc, errno));
}

fatal(f, msg)
	int f;
	char *msg;
{
	char buf[BUFSIZ];

	buf[0] = '\01';		/* error indicator */
	(void) sprintf(buf + 1, "rlogind: %s.\r\n", msg);
	(void) write(f, buf, strlen(buf));
	exit(1);
}

fatalperror(f, msg, errno)
	int f;
	char *msg;
	int errno;
{
	char buf[BUFSIZ];
	extern int sys_nerr;
	extern char *sys_errlist[];

	if ((unsigned)errno < sys_nerr)
		(void) sprintf(buf, "%s: %s", msg, sys_errlist[errno]);
	else
		(void) sprintf(buf, "%s: Error %d", msg, errno);
	fatal(f, buf);
}
