/* Copyright (c) 1986 Massachusetts Institute of Technology

   Permission to use, copy, modify, and distribute this program
   for any purpose and without fee is hereby granted, provided
   that this copyright and permission notice appear on all copies
   and supporting documentation, the name of M.I.T. not be used
   in advertising or publicity pertaining to distribution of the
   program without specific prior permission, and notice be given
   in supporting documentation that copying and distribution is
   by permission of M.I.T.  M.I.T. makes no representations about
   the suitability of this software for any purpose.  It is pro-
   vided "as is" without express or implied warranty.
*/
/*
 *	$Source: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.lib/kerberos/appl/knetd/RCS/knetd.h,v $
 *	$Header: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.lib/kerberos/appl/knetd/RCS/knetd.h,v 4.2 91/05/27 15:28:57 probe Exp $
 */

struct knet_entry {
    char *kn_name;			/* service name */
    long kn_type;			/* from /etc/protocols */
    int kn_uid;				/* uid to run the daemon as */
    char *kn_pathname;			/* path of executable */
    char *kn_arg0;			/* value of argv[0] for exec */
};
#define NUM_FIELDS 7			/* number of fields on a config line
					 * to be parsed
					 * and inserted into the structure
					 * (some are ignored)
					 */
#define MAX_ENTRIES	30		/* suggested max number of entries */
#define MAX_LINELENGTH	256		/* max length of a line in the config file */
#define KNET_SIZE (sizeof(struct knet_entry))

#ifndef CONFIG
#define CONFIG "/usr/etc/knetd.conf"
#endif

extern struct knet_entry *services;
extern int max_entries;

struct knet_entry *getconfigent();
