/*
 * $Source: /afs/net.mit.edu/user/tom/source/src/kinit/RCS/kinit.c,v $
 * $Author: tom $ 
 *
 * Copyright 1987, 1988 by the Massachusetts Institute of Technology. 
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>. 
 *
 * Routine to initialize user to Kerberos.  Prompts optionally for
 * user, instance and realm.  Authenticates user and gets a ticket
 * for the Kerberos ticket-granting service for future use. 
 *
 * Options are: 
 *
 *   -i[instance]
 *   -r[realm]
 *   -v[erbose]
 *   -l[ifetime]
 */

#ifndef	lint
static char rcsid_kinit_c[] =
"$Id: kinit.c,v 1.1 90/05/03 18:38:25 tom Exp Locker: tom $";
#endif	lint

#include <mit-copyright.h>
#include <stdio.h>
#include <pwd.h>
#include <des.h>
#include <krb.h>
#include <krb_db.h>
#include <kdc.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <sgtty.h>
#include <sys/time.h>
#include <ctype.h>

#ifndef ORGANIZATION
#define ORGANIZATION "MIT Project Athena"
#endif /*ORGANIZATION*/

#ifdef PC
#define	LEN	64		/* just guessing */
#endif	PC

#ifdef	BSD42
#include <strings.h>
#include <sys/param.h>
#if 	defined(ultrix) || defined(sun)
#define LEN	64
#else
#define	LEN	MAXHOSTNAMELEN
#endif	/* defined(ultrix) || defined(sun) */
#endif	/* BSD42 */

#define	LIFE	96	/* lifetime of ticket in 5-minute units */
#define   MAX_PRINCIPAL   10

char   *progname;
extern  kerb_debug;
extern  char *sys_errlist[];
char    *progname;
int     i, j;
int     more;

Key_schedule key_s;
C_Block      new_key;
unsigned     char *input;
char         *in_ptr;
char         input_name[ANAME_SZ];
char         input_instance[INST_SZ];
char         input_string[ANAME_SZ];

Principal principal_data[MAX_PRINCIPAL];
static    Principal old_principal;
static    Principal default_princ;
static    Principal a_name_data;
static    Principal s_name_data;
static    C_Block session_key;
static    C_Block user_key;
static    C_Block service_key;
static    C_Block master_key;
static    Key_schedule master_key_schedule;
static    char pw_str[255];
static    long master_key_version;
static    struct timeval kerb_time;
static    struct sockaddr_in client_host;
static    u_char k_flags = 0;

void cleanup(), get_input();


void
get_input(s, size, stream)
char *s;
int size;
FILE *stream;
{
	char *p;

	if (fgets(s, size, stream) == NULL)
	  exit(1);
	if ( (p = (char *) index(s, '\n')) != NULL)
		*p = '\0';
}

main(argc, argv)
    char   *argv[];
{
    char    aname[ANAME_SZ];
    char    inst[INST_SZ];
    char    realm[REALM_SZ];
    char    buf[LEN];
    char    host[LEN];
    char   *username = NULL;
    int     iflag, rflag, vflag, lflag, cflag, nflag, hflag, lifetime, k_errno;
    register char *cp;
    register i;
    C_Block key;
    static KTEXT_ST tk_st;
    KTEXT   tk = &tk_st;
    
    bzero(buf, LEN);
    bzero(host, LEN);
    bzero(inst, INST_SZ);
    bzero(realm, REALM_SZ);
    cflag = nflag = hflag = iflag = rflag = vflag = lflag = 0;
    lifetime = LIFE;
    progname = (cp = (char *) rindex(*argv, '/')) ? cp + 1 : *argv;
    gettimeofday(&kerb_time, NULL);

    while (--argc) {
	if ((*++argv)[0] != '-') {
	    if (username)
		usage();
	    username = *argv;
	    continue;
	}
	for (i = 1; (*argv)[i] != '\0'; i++)
	    switch ((*argv)[i]) {
	    case 'i':		/* Instance */
		++iflag;
		continue;
	    case 'r':		/* Realm */
		++rflag;
		continue;
	    case 'v':		/* Verbose */
		++vflag;
		continue;
	    case 'l':
		++lflag;
		continue;
	    case 'c':
		++cflag;
		continue;
	    case 'n':
		++nflag;
		continue;
	    case 'h':
		++hflag;
		continue;
	    default:
		usage();
		exit(1);
	    }
    }
    if (username &&
	(k_errno = kname_parse(aname, inst, realm, username))
	!= KSUCCESS) {
	fprintf(stderr, "%s: %s\n", progname, krb_err_txt[k_errno]);
	iflag = rflag = 1;
	username = NULL;
    }
    if (k_gethostname(host, LEN)) {
	fprintf(stderr, "%s: k_gethostname failed\n", progname);
	exit(1);
    }
    printf("%s (%s)\n", ORGANIZATION, host);
    if (username) {
	printf("Kerberos Initialization for \"%s", aname);
	if (*inst)
	    printf(".%s", inst);
	if (*realm)
	    printf("@%s", realm);
	printf("\"\n");
    } else {
	printf("Kerberos %s\n", cflag ? "Forgerization" : "Initialization");
	printf("Kerberos name: ");
	get_input(aname, sizeof(aname), stdin);
	if (!*aname)
	    exit(0);
	if (!k_isname(aname)) {
	    fprintf(stderr, "%s: bad Kerberos name format\n",
		    progname);
	    exit(1);
	}
    }
    /* optional instance */
    if (iflag) {
	printf("Kerberos instance: ");
	get_input(inst, sizeof(inst), stdin);
	if (!k_isinst(inst)) {
	    fprintf(stderr, "%s: bad Kerberos instance format\n",
		    progname);
	    exit(1);
	}
    }
    if (rflag) {
	printf("Kerberos realm: ");
	get_input(realm, sizeof(realm), stdin);
	if (!k_isrealm(realm)) {
	    fprintf(stderr, "%s: bad Kerberos realm format\n",
		    progname);
	    exit(1);
	}
    }
    if (lflag) {
	 printf("Kerberos ticket lifetime (minutes): ");
	 get_input(buf, sizeof(buf), stdin);
	 lifetime = atoi(buf);
	 if (lifetime < 5)
	      lifetime = 1;
	 else
	      lifetime /= 5;
	 /* This should be changed if the maximum ticket lifetime */
	 /* changes */
	 if (lifetime > 255)
	      lifetime = 255;
    }
    if (!*realm && krb_get_lrealm(realm, 1)) {
	fprintf(stderr, "%s: krb_get_lrealm failed\n", progname);
	exit(1);
    }
    if(hflag) {
        printf("Client hostname: ");
	get_input(host, sizeof(host), stdin);
    }
    if(get_sin_by_name(host, &client_host) < 0) {
        perror("unable to get host addr");
	exit(1);
    }
    if(!cflag) {
        k_errno = krb_get_pw_in_tkt(aname, inst, realm, "krbtgt", realm,
				    lifetime, 0);
	if (vflag) {
	    printf("Kerberos realm %s:\n", realm);
	    printf("%s\n", krb_err_txt[k_errno]);
	  } else if (k_errno) {
	    fprintf(stderr, "%s: %s\n", progname, krb_err_txt[k_errno]);
	    exit(1);
	  }
    } else { /* let's not bother anyone */
        if (kdb_get_master_key ((nflag == 0), 
				master_key, master_key_schedule) != 0) {
            fprintf(stderr, "%s: %s\n", progname, krb_err_txt[k_errno]);
	    exit (-1);
        }
	if ((master_key_version = kdb_verify_master_key(master_key,
							master_key_schedule,
							stdout)) < 0) {
  	    fprintf(stderr, "%s: %s\n", progname, krb_err_txt[k_errno]);
	    exit (-1);
	}
	if (i = check_princ(aname, inst, 0, &a_name_data)) {
	    printf("%s\n", krb_err_txt[k_errno]);
	    return;
	}
	if (i = check_princ("krbtgt", realm, lifetime, &s_name_data)) {
	    printf("%s\n", krb_err_txt[k_errno]);
	    return;
	}
	random_key(session_key);
	bcopy(&s_name_data.key_low, key, 4);
	bcopy(&s_name_data.key_high, ((long *) key) + 1, 4);
	kdb_encrypt_key(key, key, master_key, master_key_schedule, DECRYPT);
	krb_create_ticket(tk, k_flags, a_name_data.name,
			  a_name_data.instance, realm,
			  client_host.sin_addr.s_addr, session_key, lifetime,
			  kerb_time.tv_sec,
			  s_name_data.name, s_name_data.instance, key);
	in_tkt(aname, inst);
	save_credentials("krbtgt", realm, realm, session_key, lifetime,
			 1, tk, kerb_time.tv_sec);	
	bzero(key, sizeof(key));
	bzero(key_s, sizeof(key_s));
	bzero(session_key, sizeof(session_key));
	bzero(key, sizeof(key));
	bzero(&a_name_data, sizeof(a_name_data));
	bzero(&s_name_data, sizeof(s_name_data));
	
	cleanup();
    }
}


check_princ(p_name, instance, lifetime, p)
     char   *p_name;
     char   *instance;
     unsigned lifetime;
     Principal *p;
{
  static int n;
  static int more;
  long trans;

  n = kerb_get_principal(p_name, instance, p, 1, &more);
  if (n < 0) {
      printf("Database unavailable!\n");
      return (-1);
  }
  if (n == 0) {
      printf("UNKNOWN \"%s\" \"%s\"", p_name, instance, 0);
      return(-1);
  }
  if (more) {
      printf("Principal NOT UNIQUE \"%s\" \"%s\"", p_name, instance, 0);
      return(-1);
  }
  if ((p->key_low == 0) && (p->key_high == 0)) {
      printf("Null key \"%s\" \"%s\"", p_name, instance, 0);
      return(-1);
  }
  if (master_key_version != p->kdc_key_ver) {
      printf("Key vers incorrect, KRB = %d, \"%s\" \"%s\" = %d",
             master_key_version, p->name, p->instance, p->kdc_key_ver,
             0);
      return(-1);
  }
  if ((u_long) p->exp_date < (u_long) kerb_time.tv_sec) {
      printf("EXPIRED \"%s\" \"%s\"  %s", p->name, p->instance,
             stime(&(p->exp_date)), 0);
      return(-1);
  }
  return 0;
}



get_sin_by_name(name, sin)
     char *name;
     struct sockaddr_in *sin;
{
  struct hostent *hp;

  sin->sin_family = AF_INET;
  hp = gethostbyname(name);
  if (hp) {
      sin->sin_family = hp->h_addrtype;
      bcopy(hp->h_addr, (caddr_t) &(sin->sin_addr), hp->h_length);
      return(0);
  } else
    return(-1);
}


void
cleanup()
{
  bzero(master_key, sizeof(master_key));
  bzero(session_key, sizeof(session_key));
  bzero(master_key_schedule, sizeof(master_key_schedule));
  bzero(principal_data, sizeof(principal_data));
  bzero(new_key, sizeof(new_key));
  bzero(pw_str, sizeof(pw_str));
}



usage()
{
    fprintf(stderr, "Usage: %s [-irvl] [name]\n", progname);
    exit(1);
}
