/* Internals of Encrypted-stream implementation.
   Written by Ken Raeburn (Raeburn@Cygnus.COM).
   Copyright (C) 1991, 1992 by Cygnus Support.

   This file is distributed under the same terms as Kerberos.
   For copying and distribution information, please see the file
   <mit-copyright.h>.

   $Header: /afs/net.mit.edu/project/krb4/src/lib/kstream/RCS/kstream-int.h,v 1.1 92/11/10 14:48:48 tytso Exp $
 */

#include <kstream.h>

#if !defined (__STDC__) && !defined (__cplusplus) && !defined (const)
#define const /* empty */
#endif

typedef struct fifo {
  char data[10*1024];
  size_t next_write, next_read;
} fifo;

typedef struct kstream_rec {
  const struct kstream_crypt_ctl_block *ctl;
  int fd;
  int buffering : 2;
  kstream_ptr data;
  /* These should be made pointers as soon as code has been
     written to reallocate them.  Also, it would be more efficient
     to use pointers into the buffers, rather than continually shifting
     them down so unprocessed data starts at index 0.  */
  /* incoming */
  fifo in_crypt, in_clear;
  /* outgoing */
  fifo out_clear;
} kstream_rec;
