.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/KRB_SAFE_spec.ms,v $
.\"	$Author: jtkohl $
.\"	$Id: KRB_SAFE_spec.ms,v 1.26 90/12/19 17:06:33 jtkohl Exp $
.\"
.ds R# "$Id: KRB_SAFE_spec.ms,v 1.26 90/12/19 17:06:33 jtkohl Exp $
.N: sec 2 foo444 "KRB_SAFE message specification"
.PP
This section specifies the format of a message that can be used by
either side (client or server) of an
application to send a tamper-proof message to its peer.  It presumes that a
session key has previously been exchanged (for example, by using the
KRB_AP_REQ/KRB_AP_REP messages).
.N: sec 3 krb_safe_def "KRB_SAFE definition"
.PP
The KRB_SAFE message contains user data along with a collision-proof
checksum keyed with the session key.
The message fields are:
.TS
center;
lb l l.
KRB-SAFE ::=	[APPLICATION 20] SEQUENCE {
	pvno[0]	INTEGER,
	msg-type[1]	INTEGER,
	safe-body[2]	KRB-SAFE-BODY,
	cksum[3]	Checksum
}
.sp
KRB-SAFE-BODY ::=	SEQUENCE {
	user-data[0]	OCTET STRING,
	timestamp[1]	KerberosTime OPTIONAL,
	usec[2]	INTEGER OPTIONAL,
	seq-number[3]	INTEGER OPTIONAL,
	s-address[4]	HostAddress,	-- sender's addr
	r-address[5]	HostAddress OPTIONAL	-- recip's addr
}
.TE
.sp

.IP "\fBpvno\fP and \fBmsg-type\fP" 10
.br
These fields are described above in section ~sec kdc_req_def~.
\fBmsg-type\fP is KRB_SAFE.

.IP \fBsafe-body\fP 10
This field is a placeholder for the body of the KRB-SAFE message.  It is
to be encoded separately and then have the checksum computed over it,
for use in the \fBcksum\fP field.

.IP \fBcksum\fP 10
This field contains the checksum of the application data.  Checksum
details are described in section ~sec check_def~.
The checksum is computed over the encoding of the KRB-SAFE-BODY sequence.

.IP \fBuser-data\fP 10
This field is part of the KRB_SAFE and KRB_PRIV messages and contain
the application specific data that is being passed from the sender to
the recipient. 

.IP \fBtimestamp\fP 10
This field is part of the KRB_SAFE and KRB_PRIV messages.  Its
contents are the current time as known by the sender of the message.
By checking the timestamp, the recipient of the message is able to
make sure that it was recently generated, and is not a replay.

.IP \fBusec\fP 10
This field is part of the KRB_SAFE and KRB_PRIV headers.  It contains
the microsecond part of the timestamp.

.IP \fBseq-number\fP 10
.br
This field is described above in section ~sec auth_def~.

.IP \fBs-address\fP 10
This field specifies the address in use by the sender of the message.

.IP \fBr-address\fP 10
This field specifies the address in use by the recipient of the message.
It may be omitted for some uses (such as broadcast protocols), but the
recipient may arbitrarily reject such messages.  This field along with
\fBs-address\fP can be used to help detect messages which have been
incorrectly or maliciously delivered to the wrong recipient.
