#include "kauth.h"

RCSID("$Header: /src/packages/kth-krb/SourceRepository/krb4/appl/kauth/encdata.c,v 1.3 1996/03/24 06:56:57 assar Exp $");

int
write_encrypted (int fd, void *buf, size_t len, des_key_schedule schedule,
		 des_cblock *session, struct sockaddr_in *me,
		 struct sockaddr_in *him)
{
     void *outbuf;
     int32_t outlen, l;

     outbuf = malloc(len + 30);
     if (outbuf == NULL)
	  return -1;
     outlen = krb_mk_priv (buf, outbuf, len, schedule, session, me, him);
     if (outlen < 0) {
	  free(outbuf);
	  return -1;
     }
     l = outlen;
     l = htonl(l);
     if (krb_net_write (fd, &l, sizeof(l)) != sizeof(l) ||
	 krb_net_write (fd, outbuf, outlen) != outlen) {
	  free(outbuf);
	  return -1;
     }
     
     free(outbuf);
     return 0;
}


int
read_encrypted (int fd, void *buf, size_t len, void **ret,
		des_key_schedule schedule, des_cblock *session,
		struct sockaddr_in *him, struct sockaddr_in *me)
{
     int status;
     int32_t l;
     MSG_DAT msg;

     if (krb_net_read(fd, &l, sizeof(l)) != sizeof(l))
	  return -1;
     l = ntohl(l);
     if (l > len)
	  return -1;
     if (krb_net_read (fd, buf, l) != l)
	  return -1;
     status = krb_rd_priv (buf, l, schedule, session, him, me, &msg);
     if (status != RD_AP_OK) {
	  fprintf (stderr, "read_encrypted: %s\n",
		   krb_get_err_text(status));
	  return -1;
     }
     *ret  = msg.app_data;
     return  msg.app_length;
}
