/*
 * Set*uid is a mess! Different systems have different ways of doing
 * things. This function is mainly here because of Solaris that
 * doesn't have a way of setting both real and effective uid at the
 * same time. That is if you don't want to link with libucb, and we
 * don't want that.
 *
 * It could probably do better than this, but currently this seem to
 * work good enough.  
 *
 * $Id: k_setreuid.c,v 1.3 1996/02/07 10:48:40 d91-jda Exp $
 *
 */

#include "config.h"
#include <unistd.h>
#include <stdlib.h>

RCSID("$Header: /src/packages/kth-krb/SourceRepository/krb4/lib/krb/k_setreuid.c,v 1.3 1996/02/07 10:48:40 d91-jda Exp $");

int k_setreuid(int r, int e)
{
/* if there is a usable function, use that */
#ifdef HAVE_SETRESUID
  return setresuid(r, e, -1);
#else
#ifdef HAVE_SETREUID
  return setreuid(r, e);
#else

  return setuid(r); /* Weee! */

#endif /* HAVE_SETREUID */

#endif /* HAVE_SETRESUID */
}
