/*
 * $Source: /src/packages/kth-krb/SourceRepository/krb4/lib/krb/lsb_addr_comp.h,v $
 * $Author: d91-jda $
 * $Header: /src/packages/kth-krb/SourceRepository/krb4/lib/krb/lsb_addr_comp.h,v 1.1.1.1 1995/10/23 11:19:25 d91-jda Exp $
 *
 * Copyright 1988 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 *
 * Comparison macros to emulate LSBFIRST comparison results of network
 * byte-order quantities
 */

#ifndef LSB_ADDR_COMP_DEFS
#define LSB_ADDR_COMP_DEFS

#include "config.h"

#ifdef    WORDS_BIGENDIAN

#define u_char_comp(x,y) \
        (((x)>(y))?(1):(((x)==(y))?(0):(-1)))
/* This is gross, but... */
#define lsb_net_ulong_less(x, y) long_less_than((u_char *)&x, (u_char *)&y)
#define lsb_net_ushort_less(x, y) short_less_than((u_char *)&x, (u_char *)&y)

#define long_less_than(x,y) \
        (u_char_comp((x)[3],(y)[3])?u_char_comp((x)[3],(y)[3]): \
	 (u_char_comp((x)[2],(y)[2])?u_char_comp((x)[2],(y)[2]): \
	  (u_char_comp((x)[1],(y)[1])?u_char_comp((x)[1],(y)[1]): \
	   (u_char_comp((x)[0],(y)[0])))))
#define short_less_than(x,y) \
	  (u_char_comp((x)[1],(y)[1])?u_char_comp((x)[1],(y)[1]): \
	   (u_char_comp((x)[0],(y)[0])))

#else /* !WORDS_BIGENDIAN */

#define lsb_net_ulong_less(x,y) ((x < y) ? -1 : ((x > y) ? 1 : 0))
#define lsb_net_ushort_less(x,y) ((x < y) ? -1 : ((x > y) ? 1 : 0))

#endif /* !WORDS_BIGENDIAN */

#endif /*  LSB_ADDR_COMP_DEFS */
