#define LOGALL
#define KERBEROS
#define KLOGIN_PARANOID
#define LOGIN_ACCESS
#define PASSWD_FALLBACK

#include "config.h"
#include "protos.h"

/* Any better way to test NO_MOTD? */
#if (SunOS == 5) || defined(__hpux)
#define NO_MOTD
#endif

#ifdef HAVE_SHADOW_H
#define SYSV_SHADOW
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
extern char *optarg;
extern int optind, opterr;
#include <setjmp.h>

#include <stdarg.h>

#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <time.h>
#include <sys/stat.h>
#ifndef S_ISTXT
#define S_ISTXT S_ISVTX
#endif
#include <fcntl.h>
#include <dirent.h>
#include <signal.h>
#include <sys/time.h>
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif /* HAVE_SYS_RESOURCE_H */
#include <sys/wait.h>
#include <sys/param.h>
#if defined(HAVE_SYS_IOCTL_H) && SunOS != 4
#include <sys/ioctl.h>
#endif
#ifdef HAVE_SYS_IOCCOM_H
#include <sys/ioccom.h>
#endif

#ifndef NCARGS
#define NCARGS  0x100000 /* (absolute) max # characters in exec arglist */
#endif
#include <pwd.h>
#include <grp.h>
#include <utime.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef HAVE_SYS_SOCKIO_H
#include <sys/sockio.h>
#endif

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifdef HAVE_SYS_FILIO_H
#include <sys/filio.h>
#endif

#ifdef HAVE_SYS_STREAM_H
#ifdef HAVE_SYS_UIO_H
#include <sys/uio.h>
#endif /* HAVE_SYS_UIO_H */
#include <sys/stream.h>
#endif /* HAVE_SYS_STREAM_H */

#ifdef HAVE_SYS_PTYVAR_H
#include <sys/tty.h>
#include <sys/ptyvar.h>
#endif /* HAVE_SYS_PTYVAR_H */

#include <syslog.h>
/* Misc definitions for old syslogs */

#ifndef LOG_DAEMON
#define openlog(id,option,facility) openlog((id),(option))
#endif
#ifndef LOG_ODELAY
#define LOG_ODELAY 0
#endif
#ifndef LOG_CONS
#define LOG_CONS 0
#endif
#ifndef LOG_AUTH
#define LOG_AUTH 0
#endif
#ifndef LOG_AUTHPRIV
#define LOG_AUTHPRIV LOG_AUTH
#endif

/* Strange ioctls that are not always defined */

#ifndef TIOCPKT_FLUSHWRITE
#define TIOCPKT_FLUSHWRITE      0x02
#endif
 
#ifndef TIOCPKT_NOSTOP
#define TIOCPKT_NOSTOP  0x10
#endif
 
#ifndef TIOCPKT_DOSTOP
#define TIOCPKT_DOSTOP  0x20
#endif

#ifndef TIOCPKT
#define TIOCPKT		_IOW('t', 112, int)   /* pty: set/clear packet mode */
#endif

#ifdef HAVE_LASTLOG_H
#include <lastlog.h>
#endif

#ifdef HAVE_LOGIN_H
#include <login.h>
#endif

#ifdef HAVE_TTYENT_H
#include <ttyent.h>
#endif

#ifdef HAVE_STROPTS_H
#include <stropts.h>
#endif

#include <utmp.h>
#ifndef UT_NAMESIZE
#define UT_NAMESIZE     sizeof(((struct utmp *)0)->ut_name)
#endif

#ifdef HAVE_UTMPX_H
#include <utmpx.h>
#endif

#ifdef HAVE_USERPW_H
#include <userpw.h>
#endif /* HAVE_USERPW_H */

#ifdef HAVE_USERSEC_H
#include <usersec.h>
#endif /* HAVE_USERSEC_H */

#ifndef PRIO_PROCESS
#define PRIO_PROCESS 0
#endif

#include <roken.h>

#include <des.h>
#include <krb.h>
#include <kafs.h>

int kcmd(int *sock, char **ahost, u_int16_t rport, char *locuser, char *remuser, char *cmd, int *fd2p, KTEXT ticket, char *service, char *realm, CREDENTIALS *cred, Key_schedule schedule, MSG_DAT *msg_data, struct sockaddr_in *laddr, struct sockaddr_in *faddr, int32_t authopts);

int krcmd(char **ahost, u_int16_t rport, char *remuser, char *cmd, int *fd2p, char *realm);

int krcmd_mutual(char **ahost, u_int16_t rport, char *remuser, char *cmd, int *fd2p, char *realm, CREDENTIALS *cred, Key_schedule sched);

int klogin(struct passwd *pw, char *instance, char *localhost, char *password);

typedef struct {
        int cnt;
        char *buf;
} BUF;

char *colon(char *cp);
int okname(char *cp0);
int susystem(char *s, int userid);

#ifdef __GNUC__
struct termios;
struct winsize;
int forkpty __P((int *amaster, char *name, struct termios *termp, struct winsize *winp));
#else
int forkpty ();
#endif

#ifndef MODEMASK
#define	MODEMASK	(S_ISUID|S_ISGID|S_ISTXT|S_IRWXU|S_IRWXG|S_IRWXO)
#endif

#include "err.h"
#ifdef HAVE_PATHS_H
#include <paths.h>
#endif
#ifdef HAVE_MAILLOCK_H
#include <maillock.h>
#endif
#include "pathnames.h"

#ifndef MAX
#define MAX(a, b) ((a) > (b) ? (a) : (b))
#endif

char *crypt __P((const char *, const char *));

void stty_default __P((void));

int utmpx_login(char *line, char *user, char *host);

void sysv_newenv(int argc, char **argv, struct passwd *pwd,
		 char *term, int pflag);

int login_access(char *user, char *from);
#ifndef HAVE_IRUSEROK
int iruserok(u_int32_t raddr, int superuser, const char *ruser,
	     const char *luser);
#endif
void fatal(int f, const char *msg, int syserr);

extern int LEFT_JUSTIFIED;
int des_enc_read(int fd,char *buf,int len,des_key_schedule sched,
	des_cblock *iv);
int des_enc_write(int fd,char *buf,int len,des_key_schedule sched,
	des_cblock *iv);

void sysv_defaults(void);
void utmp_login(char *tty, char *username, char *hostname);
void	 sleepexit __P((int));

#ifndef HAVE_SETPRIORITY
#define setpriority(which, who, niceval) 0
#endif

#ifndef HAVE_GETPRIORITY
#define getpriority(which, who) 0
#endif

