#include "krb_locl.h"

RCSID("$Id: lsb_addr_comp.c,v 1.4 1996/05/04 01:52:55 d91-jda Exp $");

#include "lsb_addr_comp.h"

int
krb_lsb_antinet_ulong_cmp(u_int32_t x, u_int32_t y)
{
    u_int8_t *p = (u_int8_t*) &x;
    u_int8_t *q = (u_int8_t*) &y;

    x = (p[3] << 24) | (p[2] << 16) | (p[1] << 8) | p[0];
    y = (q[3] << 24) | (q[2] << 16) | (q[1] << 8) | q[0];

    if(x > y)
	return 1;
    if(x < y)
	return -1;
    return 0;
}

int
krb_lsb_antinet_ushort_cmp(u_int16_t x, u_int16_t y)
{
    u_int8_t *p = (u_int8_t*) &x;
    u_int8_t *q = (u_int8_t*) &y;

    x = (p[1] << 8) | p[0];
    y = (q[1] << 8) | q[0];

    if(x > y)
	return 1;
    if(x < y)
	return -1;
    return 0;
}
