#include "krb_locl.h"

RCSID("$Id: rw.c,v 1.2 1996/06/17 15:57:39 joda Exp $");

int
get_int(unsigned char *from, u_int32_t *to, int size, int lsb)
{
    int i;

    *to = 0;
    if(lsb){
	for(i = size-1; i >= 0; i--)
	    *to = (*to << 8) | from[i];
    }else{
	for(i = 0; i < size; i++)
	    *to = (*to << 8) | from[i];
    }
    return size;
}

int
put_int(u_int32_t from, void *to, int size)
{
    int i;
    char *p = (char*)to;
    for(i = size - 1; i >= 0; i--){
	p[i] = from & 0xff;
	from >>= 8;
    }
    return size;
}


/* addresses are always sent in network byte order */

int
get_address(void *from, u_int32_t *to)
{
    unsigned char *p = (unsigned char*)from;
    *to = htonl((p[0] << 24) | (p[1] << 16) | (p[2] << 8) | p[3]);
    return 4;
}

int
put_address(u_int32_t addr, void *to)
{
    return put_int(ntohl(addr), to, 4);
}

int
put_string(char *from, char *to)
{
    strcpy(to, from);
    return strlen(from) + 1;
}

int
get_string(char *from, char *to)
{
    return put_string(from, to);
}

int
get_nir(char *from, char *name, char *instance, char *realm)
{
    char *p = from;

    p += get_string(p, name);
    p += get_string(p, instance);
    if(realm)
	p += get_string(p, realm);
    return p - from;
}


int
put_nir(char *name, char *instance, char *realm, char *to)
{
    char *p = to;
    p += put_string(name, p);
    p += put_string(instance, p);
    if(realm)
	p += put_string(realm, p);
    return p - to;
}
