#include "krb_locl.h"

RCSID("$Id: cr_err_reply.c,v 1.6 1996/08/11 21:37:16 assar Exp $");

/*
 * This routine is used by the Kerberos authentication server to
 * create an error reply packet to send back to its client.
 *
 * It takes a pointer to the packet to be built, the name, instance,
 * and realm of the principal, the client's timestamp, an error code
 * and an error string as arguments.  Its return value is undefined.
 *
 * The packet is built in the following format:
 * 
 * type			variable	   data
 *			or constant
 * ----			-----------	   ----
 *
 * unsigned char	req_ack_vno	   protocol version number
 * 
 * unsigned char	AUTH_MSG_ERR_REPLY protocol message type
 * 
 * [least significant	HOST_BYTE_ORDER	   sender's (server's) byte
 * bit of above field]			   order
 * 
 * string		pname		   principal's name
 * 
 * string		pinst		   principal's instance
 * 
 * string		prealm		   principal's realm
 * 
 * unsigned long	time_ws		   client's timestamp
 * 
 * unsigned long	e		   error code
 * 
 * string		e_string	   error text
 */

void
cr_err_reply(KTEXT pkt, char *pname, char *pinst, char *prealm, 
	     u_int32_t time_ws, u_int32_t e, char *e_string)
{
    unsigned char *p = pkt->dat;
    
    p += krb_put_int(KRB_PROT_VERSION, p, 1);
    p += krb_put_int(AUTH_MSG_ERR_REPLY, p, 1);

    if (pname == NULL) pname = "";
    if (pinst == NULL) pinst = "";
    if (prealm == NULL) prealm = "";

    p += krb_put_nir(pname, pinst, prealm, p);
    
    p += krb_put_int(time_ws, p, 4);

    p += krb_put_int(e, p, 4);

    p += krb_put_string(e_string, p);

    pkt->length = p - pkt->dat;
}
