#include "krb_locl.h"

RCSID("$Id: k_name_to_name.c,v 1.7 1996/08/18 23:22:09 assar Exp $");

/* convert host to a more fully qualified domain name, returns 0 if
 * phost is the same as host, 1 otherwise. phost should be at least
 * MaxHostNameLen+1 bytes long
 */

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

int
k_name_to_name(const char *host, char *phost)
{
    struct hostent *hp;
    struct in_addr adr;
    
    adr.s_addr = inet_addr(host);
    hp = gethostbyname(host);
    if (hp == NULL && adr.s_addr != INADDR_NONE)
	hp = gethostbyaddr((char *)&adr, sizeof(adr), AF_INET);
    if (hp == NULL)
	strcpy(phost, host);
    else
	strcpy(phost, hp->h_name);

    if (strcmp(phost, host) == 0)
	return 0;
    else
	return 1;
}
/*
 * Local Variables:
 * c-basic-offset: 4 
 * End:
 */
