/*
 * Copyright 1987, 1988 by MIT Student Information Processing Board.
 *
 * For copyright info, see mit-sipb-copyright.h.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#include "mit-sipb-copyright.h"

#include <com_err.h>
#include <error_table.h>

RCSID("$Id: com_err.c,v 1.8 1996/08/26 22:48:52 assar Exp $");

static void
default_com_err_proc (const char *whoami, long code, const char *fmt, va_list args)
{
    if (whoami) {
	fputs(whoami, stderr);
	fputs(": ", stderr);
    }
    if (code) {
	fputs(error_message(code), stderr);
	fputs(" ", stderr);
    }
    if (fmt) {
        vfprintf (stderr, fmt, args);
    }
    putc('\n', stderr);
    /* should do this only on a tty in raw mode */
    putc('\r', stderr);
    fflush(stderr);
}


static errf com_err_hook = default_com_err_proc;

void com_err_va (const char *whoami, long code, const char *fmt, va_list args)
{
  if (! com_err_hook)
        com_err_hook = default_com_err_proc;
    (*com_err_hook) (whoami, code, fmt, args);
}

void com_err (const char *whoami,
	      long code,
	      const char *fmt, ...)
{
    va_list pvar;

    if (!com_err_hook)
	com_err_hook = default_com_err_proc;
    va_start(pvar, fmt);
    com_err_va (whoami, code, fmt, pvar);
    va_end(pvar);
}

errf set_com_err_hook (errf new_proc)
{
    errf x = com_err_hook;

    if (new_proc)
	com_err_hook = new_proc;
    else
	com_err_hook = default_com_err_proc;

    return x;
}

errf reset_com_err_hook (void) 
{
    errf x = com_err_hook;
    com_err_hook = default_com_err_proc;
    return x;
}
