//
//
// Option
//
//

#include <string.h>
#include "Telnet.h"
#include "TelnetCodes.h"
#include "Option.h"
#include "TelnetEngine.h"

// State variable values

Option::Option (CharStream *str, TelnetEngine* engine, unsigned char opt)
{
	option = opt;
	stream = str;
	pTEngine = engine;;
	
	// Initialize state variables
}

Option::~Option ()
{
}

/*short
Option::OptionFor (unsigned char opt)
{
	return option == opt;
}
*/
void
Option::SendReply (void *buff, short len)
{
	pTEngine->Send ((char *)buff, len);
}

short
Option::ReadToIACSE ()
{
	unsigned char c;

	while (1) {
		if (!stream->GetChar (&c))
			return 1;
		if (c == IAC) {
			if (!stream->GetChar (&c))
				return 1;
			if (c == SE)
				break;
		}
	}
	
	return 0;
}

void
Option::SendWILL ()
{
	unsigned char buff[3];
	
	buff[0] = IAC;
	buff[1] = WILL;
	buff[2] = option;
	
	SendReply (buff, 3);
}

void
Option::PadBinaryBuff (unsigned char *in, unsigned long *inLen,
					   unsigned char *out, unsigned long *outLen)
{
	unsigned long i;
	int len = 0;
	
	for (i = 0; i < *inLen; i++) {
		if (*in == IAC) {
			*out++ = IAC;
			len++;
		}
		*out++ = *in++;
	}
	*outLen = *inLen + len;
}	



Option::Option(void)
{

}

// Override in subclasses if needed.
//void Option::ExecOption(unsigned int Command) {}
