#include <string.h>
#include "WinSizeOption.h"
#include "EmulatorEngine.h"

void
WinSizeOption::NegotiateOption (unsigned char command)
{
	YesNoOption::NegotiateOption (command);
	negotiated = true;
	int width, height;
	pTEngine->mTelnetSession->mTerminalEngine->GetCharWindowSize(&width, &height);
	SendWinSize (width, height);
}

void WinSizeOption::ExecOption(unsigned int Command, void* Data)
{
	if(Command == WINSIZE_CHANGED)
		SendWinSize(((unsigned short*)Data)[0], ((unsigned short*)Data)[1]);
}

void
WinSizeOption::SendWinSize (unsigned short width, unsigned short height)
{
	unsigned char buff[9];
	if (negotiated) {
		buff[0] = IAC;
		buff[1] = SB;
		buff[2] = NAWS;
		buff[3] = width>>8;
		buff[4] = width&0xff;
		buff[5] = height>>8;
		buff[6] = height&0xff;
		buff[7] = IAC;
		buff[8] = SE;
		SendReply (buff, 9);
	}
}			