//
//
// Option
//
//

#ifndef OPTION__H
#define OPTION__H

// Define some ansi C++ keywords.
#define ANSI_BOOLEAN
#define Boolean bool
#define bool	BOOL
#define true	TRUE
#define false	FALSE

#include "CharStream.h"
#include "TelnetCodes.h"

class TelnetEngine;

//
//
// Option
//
// Base class for options
//
class Option {
public:
	// Constructors and destructors
	Option(void);
	~Option ();
	Option (CharStream* str, TelnetEngine *engine, unsigned char option);

	// NegotiateOption, override in subclasses.
	virtual void  NegotiateOption (unsigned char command) = 0;

	// ExecOption, override in subclasses if needed.
	virtual void ExecOption(unsigned int Command, void* Data = NULL) {}
	
	// OptionFor, returns true if object negotiates opt
	// Overridden in DenyAllOption only (where it returns true for all opt:s)
	// virtual short OptionFor (unsigned char opt);

	unsigned char option;

protected:
	void          SendReply (void* buff, short len);
	void          SendWILL ();
	short         ReadToIACSE ();
	void          PadBinaryBuff (unsigned char *in, unsigned long *inLen,
								 unsigned char *out, unsigned long *outLen);
	
	
	
	// Variables
	CharStream    *stream;
	TelnetEngine  *pTEngine;
	// State variables as in RFC 1143
	short         us, usq;
	short         him, himq;
};


#endif