/*
 * $Id: error_message.c,v 1.9 1996/10/27 23:52:22 assar Exp $
 *
 * Copyright 1987 by the Student Information Processing Board
 * of the Massachusetts Institute of Technology
 *
 * For copyright info, see "mit-sipb-copyright.h".
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
RCSID("$Id: error_message.c,v 1.9 1996/10/27 23:52:22 assar Exp $");
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include "error_table.h"
#include "com_err.h"
#include "mit-sipb-copyright.h"

static char buffer[25];

#ifndef HAVE_STRERROR
extern char const *const sys_errlist[];
extern const int sys_nerr;

static const char *
et_strerror(int err)
{
    if (0 <= err && err < sys_nerr)
	return sys_errlist[err];
    else {
	static char buf[64];

	sprintf(buf, "Error %d", err);
	return buf;
    }
}
	
#else

#define et_strerror strerror

#endif /* HAVE_STRERROR */

const char * error_message (long code)
{
    int offset;
    struct et_list *et;
    int table_num;
    int started = 0;
    char *cp;

    offset = code & ((1<<ERRCODE_RANGE)-1);
    table_num = code - offset;
    if (!table_num) {
	return et_strerror(offset);
    }
    for (et = _et_list; et; et = et->next) {
	if (et->table->base == table_num) {
	    /* This is the right table */
	    if (et->table->n_msgs <= offset)
		goto oops;
	    return(et->table->msgs[offset]);
	}
    }
oops:
    strcpy (buffer, "Unknown code ");
    if (table_num) {
	strcat (buffer, error_table_name (table_num));
	strcat (buffer, " ");
    }
    for (cp = buffer; *cp; cp++)
	;
    if (offset >= 100) {
	*cp++ = '0' + offset / 100;
	offset %= 100;
	started++;
    }
    if (started || offset >= 10) {
	*cp++ = '0' + offset / 10;
	offset %= 10;
    }
    *cp++ = '0' + offset;
    *cp = '\0';
    return(buffer);
}
