#include "krb_locl.h"

RCSID("$Id: rd_err.c,v 1.4 1996/05/15 03:39:49 joda Exp $");

/*
 * Given an AUTH_MSG_APPL_ERR message, "in" and its length "in_length",
 * return the error code from the message in "code" and the text in
 * "m_data" as follows:
 *
 *	m_data->app_data	points to the error text
 *	m_data->app_length	points to the length of the error text
 *
 * If all goes well, return RD_AP_OK.  If the version number
 * is wrong, return RD_AP_VERSION, and if it's not an AUTH_MSG_APPL_ERR
 * type message, return RD_AP_MSG_TYPE.
 *
 * The AUTH_MSG_APPL_ERR message format can be found in mk_err.c
 */

int
krb_rd_err(u_char *in, u_int32_t in_length, int32_t *code, MSG_DAT *m_data)
{
    unsigned char *p = (unsigned char*)in;
    
    unsigned char pvno, type;
    int little_endian;

    pvno = *p++;
    if(pvno != KRB_PROT_VERSION)
	return RD_AP_VERSION;
    
    type = *p++;
    little_endian = type & 1;
    type &= ~1;
    
    if(type != AUTH_MSG_APPL_ERR)
	return RD_AP_MSG_TYPE;
    
    p += get_int(p, &code, 4, little_endian);
    
    m_data->app_data = p;
    m_data->app_length = in_length; /* XXX is this correct? */
    return KSUCCESS;
}
