;skeydict.star: creates an array of system binaries (20-bit
;integers) containing the standard S/KEY dictionary

	header	`E'

	data.a	type_array	;an array
bstart:	data.a	bend-bstart	;with this nibble length
	data.a	type_short	;of binary integers
	data.a	1		;with one dimension
	data.a	2048		;of 2048 elements
	data.a	#1    	;   0 A
	data.a	#1441 	;   1 ABE
	data.a	#1461 	;   2 ACE
	data.a	#5061 	;   3 ACT
	data.a	#81   	;   4 AD
	data.a	#481  	;   5 ADA
	data.a	#1081 	;   6 ADD
	data.a	#3ce1 	;   7 AGO
	data.a	#1121 	;   8 AID
	data.a	#3521 	;   9 AIM
	data.a	#4921 	;  10 AIR
	data.a	#3181 	;  11 ALL
	data.a	#4181 	;  12 ALP
	data.a	#1a1  	;  13 AM
	data.a	#65a1 	;  14 AMY
	data.a	#1c1  	;  15 AN
	data.a	#5c1  	;  16 ANA
	data.a	#11c1 	;  17 AND
	data.a	#39c1 	;  18 ANN
	data.a	#51c1 	;  19 ANT
	data.a	#65c1 	;  20 ANY
	data.a	#1601 	;  21 APE
	data.a	#4e01 	;  22 APS
	data.a	#5201 	;  23 APT
	data.a	#e41  	;  24 ARC
	data.a	#1641 	;  25 ARE
	data.a	#2e41 	;  26 ARK
	data.a	#3641 	;  27 ARM
	data.a	#5241 	;  28 ART
	data.a	#261  	;  29 AS
	data.a	#2261 	;  30 ASH
	data.a	#2e61 	;  31 ASK
	data.a	#281  	;  32 AT
	data.a	#1681 	;  33 ATE
	data.a	#1ea1 	;  34 AUG
	data.a	#2ea1 	;  35 AUK
	data.a	#16c1 	;  36 AVE
	data.a	#16e1 	;  37 AWE
	data.a	#2ee1 	;  38 AWK
	data.a	#32e1 	;  39 AWL
	data.a	#3ae1 	;  40 AWN
	data.a	#301  	;  41 AX
	data.a	#1721 	;  42 AYE
	data.a	#1022 	;  43 BAD
	data.a	#1c22 	;  44 BAG
	data.a	#2022 	;  45 BAH
	data.a	#3422 	;  46 BAM
	data.a	#3822 	;  47 BAN
	data.a	#4822 	;  48 BAR
	data.a	#5022 	;  49 BAT
	data.a	#6422 	;  50 BAY
	data.a	#a2   	;  51 BE
	data.a	#10a2 	;  52 BED
	data.a	#14a2 	;  53 BEE
	data.a	#1ca2 	;  54 BEG
	data.a	#38a2 	;  55 BEN
	data.a	#50a2 	;  56 BET
	data.a	#64a2 	;  57 BEY
	data.a	#922  	;  58 BIB
	data.a	#1122 	;  59 BID
	data.a	#1d22 	;  60 BIG
	data.a	#3922 	;  61 BIN
	data.a	#5122 	;  62 BIT
	data.a	#9e2  	;  63 BOB
	data.a	#1de2 	;  64 BOG
	data.a	#39e2 	;  65 BON
	data.a	#3de2 	;  66 BOO
	data.a	#41e2 	;  67 BOP
	data.a	#5de2 	;  68 BOW
	data.a	#65e2 	;  69 BOY
	data.a	#aa2  	;  70 BUB
	data.a	#12a2 	;  71 BUD
	data.a	#1ea2 	;  72 BUG
	data.a	#36a2 	;  73 BUM
	data.a	#3aa2 	;  74 BUN
	data.a	#4ea2 	;  75 BUS
	data.a	#52a2 	;  76 BUT
	data.a	#66a2 	;  77 BUY
	data.a	#322  	;  78 BY
	data.a	#1722 	;  79 BYE
	data.a	#823  	;  80 CAB
	data.a	#3023 	;  81 CAL
	data.a	#3423 	;  82 CAM
	data.a	#3823 	;  83 CAN
	data.a	#4023 	;  84 CAP
	data.a	#4823 	;  85 CAR
	data.a	#5023 	;  86 CAT
	data.a	#5c23 	;  87 CAW
	data.a	#11e3 	;  88 COD
	data.a	#1de3 	;  89 COG
	data.a	#31e3 	;  90 COL
	data.a	#39e3 	;  91 CON
	data.a	#3de3 	;  92 COO
	data.a	#41e3 	;  93 COP
	data.a	#51e3 	;  94 COT
	data.a	#5de3 	;  95 COW
	data.a	#65e3 	;  96 COY
	data.a	#6643 	;  97 CRY
	data.a	#aa3  	;  98 CUB
	data.a	#16a3 	;  99 CUE
	data.a	#42a3 	; 100 CUP
	data.a	#4aa3 	; 101 CUR
	data.a	#52a3 	; 102 CUT
	data.a	#824  	; 103 DAB
	data.a	#1024 	; 104 DAD
	data.a	#3424 	; 105 DAM
	data.a	#3824 	; 106 DAN
	data.a	#4824 	; 107 DAR
	data.a	#6424 	; 108 DAY
	data.a	#14a4 	; 109 DEE
	data.a	#30a4 	; 110 DEL
	data.a	#38a4 	; 111 DEN
	data.a	#4ca4 	; 112 DES
	data.a	#5ca4 	; 113 DEW
	data.a	#1124 	; 114 DID
	data.a	#1524 	; 115 DIE
	data.a	#1d24 	; 116 DIG
	data.a	#3924 	; 117 DIN
	data.a	#4124 	; 118 DIP
	data.a	#1e4  	; 119 DO
	data.a	#15e4 	; 120 DOE
	data.a	#1de4 	; 121 DOG
	data.a	#39e4 	; 122 DON
	data.a	#51e4 	; 123 DOT
	data.a	#5de4 	; 124 DOW
	data.a	#6644 	; 125 DRY
	data.a	#aa4  	; 126 DUB
	data.a	#12a4 	; 127 DUD
	data.a	#16a4 	; 128 DUE
	data.a	#1ea4 	; 129 DUG
	data.a	#3aa4 	; 130 DUN
	data.a	#4825 	; 131 EAR
	data.a	#5025 	; 132 EAT
	data.a	#85   	; 133 ED
	data.a	#30a5 	; 134 EEL
	data.a	#1ce5 	; 135 EGG
	data.a	#3ce5 	; 136 EGO
	data.a	#2585 	; 137 ELI
	data.a	#2d85 	; 138 ELK
	data.a	#3585 	; 139 ELM
	data.a	#6585 	; 140 ELY
	data.a	#1a5  	; 141 EM
	data.a	#11c5 	; 142 END
	data.a	#5265 	; 143 EST
	data.a	#e85  	; 144 ETC
	data.a	#6c5  	; 145 EVA
	data.a	#16c5 	; 146 EVE
	data.a	#16e5 	; 147 EWE
	data.a	#1725 	; 148 EYE
	data.a	#1026 	; 149 FAD
	data.a	#3826 	; 150 FAN
	data.a	#4826 	; 151 FAR
	data.a	#5026 	; 152 FAT
	data.a	#6426 	; 153 FAY
	data.a	#10a6 	; 154 FED
	data.a	#14a6 	; 155 FEE
	data.a	#5ca6 	; 156 FEW
	data.a	#926  	; 157 FIB
	data.a	#1d26 	; 158 FIG
	data.a	#3926 	; 159 FIN
	data.a	#4926 	; 160 FIR
	data.a	#5126 	; 161 FIT
	data.a	#3d86 	; 162 FLO
	data.a	#6586 	; 163 FLY
	data.a	#15e6 	; 164 FOE
	data.a	#1de6 	; 165 FOG
	data.a	#49e6 	; 166 FOR
	data.a	#6646 	; 167 FRY
	data.a	#36a6 	; 168 FUM
	data.a	#3aa6 	; 169 FUN
	data.a	#4aa6 	; 170 FUR
	data.a	#827  	; 171 GAB
	data.a	#1027 	; 172 GAD
	data.a	#1c27 	; 173 GAG
	data.a	#3027 	; 174 GAL
	data.a	#3427 	; 175 GAM
	data.a	#4027 	; 176 GAP
	data.a	#4c27 	; 177 GAS
	data.a	#6427 	; 178 GAY
	data.a	#14a7 	; 179 GEE
	data.a	#30a7 	; 180 GEL
	data.a	#34a7 	; 181 GEM
	data.a	#50a7 	; 182 GET
	data.a	#1d27 	; 183 GIG
	data.a	#3127 	; 184 GIL
	data.a	#3927 	; 185 GIN
	data.a	#1e7  	; 186 GO
	data.a	#51e7 	; 187 GOT
	data.a	#36a7 	; 188 GUM
	data.a	#3aa7 	; 189 GUN
	data.a	#4ea7 	; 190 GUS
	data.a	#52a7 	; 191 GUT
	data.a	#66a7 	; 192 GUY
	data.a	#3727 	; 193 GYM
	data.a	#4327 	; 194 GYP
	data.a	#28   	; 195 HA
	data.a	#1028 	; 196 HAD
	data.a	#3028 	; 197 HAL
	data.a	#3428 	; 198 HAM
	data.a	#3828 	; 199 HAN
	data.a	#4028 	; 200 HAP
	data.a	#4c28 	; 201 HAS
	data.a	#5028 	; 202 HAT
	data.a	#5c28 	; 203 HAW
	data.a	#6428 	; 204 HAY
	data.a	#a8   	; 205 HE
	data.a	#34a8 	; 206 HEM
	data.a	#38a8 	; 207 HEN
	data.a	#48a8 	; 208 HER
	data.a	#5ca8 	; 209 HEW
	data.a	#64a8 	; 210 HEY
	data.a	#128  	; 211 HI
	data.a	#1128 	; 212 HID
	data.a	#3528 	; 213 HIM
	data.a	#4128 	; 214 HIP
	data.a	#4d28 	; 215 HIS
	data.a	#5128 	; 216 HIT
	data.a	#1e8  	; 217 HO
	data.a	#9e8  	; 218 HOB
	data.a	#de8  	; 219 HOC
	data.a	#15e8 	; 220 HOE
	data.a	#1de8 	; 221 HOG
	data.a	#41e8 	; 222 HOP
	data.a	#51e8 	; 223 HOT
	data.a	#5de8 	; 224 HOW
	data.a	#aa8  	; 225 HUB
	data.a	#16a8 	; 226 HUE
	data.a	#1ea8 	; 227 HUG
	data.a	#22a8 	; 228 HUH
	data.a	#36a8 	; 229 HUM
	data.a	#52a8 	; 230 HUT
	data.a	#9    	; 231 I
	data.a	#6469 	; 232 ICY
	data.a	#489  	; 233 IDA
	data.a	#c9   	; 234 IF
	data.a	#1569 	; 235 IKE
	data.a	#3189 	; 236 ILL
	data.a	#2dc9 	; 237 INK
	data.a	#39c9 	; 238 INN
	data.a	#1e9  	; 239 IO
	data.a	#39e9 	; 240 ION
	data.a	#229  	; 241 IQ
	data.a	#649  	; 242 IRA
	data.a	#1649 	; 243 IRE
	data.a	#2e49 	; 244 IRK
	data.a	#269  	; 245 IS
	data.a	#289  	; 246 IT
	data.a	#4e89 	; 247 ITS
	data.a	#66c9 	; 248 IVY
	data.a	#82a  	; 249 JAB
	data.a	#1c2a 	; 250 JAG
	data.a	#342a 	; 251 JAM
	data.a	#382a 	; 252 JAN
	data.a	#482a 	; 253 JAR
	data.a	#5c2a 	; 254 JAW
	data.a	#642a 	; 255 JAY
	data.a	#50aa 	; 256 JET
	data.a	#1d2a 	; 257 JIG
	data.a	#352a 	; 258 JIM
	data.a	#1ea  	; 259 JO
	data.a	#9ea  	; 260 JOB
	data.a	#15ea 	; 261 JOE
	data.a	#1dea 	; 262 JOG
	data.a	#51ea 	; 263 JOT
	data.a	#65ea 	; 264 JOY
	data.a	#1eaa 	; 265 JUG
	data.a	#52aa 	; 266 JUT
	data.a	#642b 	; 267 KAY
	data.a	#1cab 	; 268 KEG
	data.a	#38ab 	; 269 KEN
	data.a	#64ab 	; 270 KEY
	data.a	#112b 	; 271 KID
	data.a	#352b 	; 272 KIM
	data.a	#392b 	; 273 KIN
	data.a	#512b 	; 274 KIT
	data.a	#2c   	; 275 LA
	data.a	#82c  	; 276 LAB
	data.a	#c2c  	; 277 LAC
	data.a	#102c 	; 278 LAD
	data.a	#1c2c 	; 279 LAG
	data.a	#342c 	; 280 LAM
	data.a	#402c 	; 281 LAP
	data.a	#5c2c 	; 282 LAW
	data.a	#642c 	; 283 LAY
	data.a	#4ac  	; 284 LEA
	data.a	#10ac 	; 285 LED
	data.a	#14ac 	; 286 LEE
	data.a	#1cac 	; 287 LEG
	data.a	#38ac 	; 288 LEN
	data.a	#3cac 	; 289 LEO
	data.a	#50ac 	; 290 LET
	data.a	#5cac 	; 291 LEW
	data.a	#112c 	; 292 LID
	data.a	#152c 	; 293 LIE
	data.a	#392c 	; 294 LIN
	data.a	#412c 	; 295 LIP
	data.a	#512c 	; 296 LIT
	data.a	#1ec  	; 297 LO
	data.a	#9ec  	; 298 LOB
	data.a	#1dec 	; 299 LOG
	data.a	#41ec 	; 300 LOP
	data.a	#4dec 	; 301 LOS
	data.a	#51ec 	; 302 LOT
	data.a	#55ec 	; 303 LOU
	data.a	#5dec 	; 304 LOW
	data.a	#65ec 	; 305 LOY
	data.a	#1eac 	; 306 LUG
	data.a	#172c 	; 307 LYE
	data.a	#2d   	; 308 MA
	data.a	#c2d  	; 309 MAC
	data.a	#102d 	; 310 MAD
	data.a	#142d 	; 311 MAE
	data.a	#382d 	; 312 MAN
	data.a	#3c2d 	; 313 MAO
	data.a	#402d 	; 314 MAP
	data.a	#502d 	; 315 MAT
	data.a	#5c2d 	; 316 MAW
	data.a	#642d 	; 317 MAY
	data.a	#ad   	; 318 ME
	data.a	#1cad 	; 319 MEG
	data.a	#30ad 	; 320 MEL
	data.a	#38ad 	; 321 MEN
	data.a	#50ad 	; 322 MET
	data.a	#5cad 	; 323 MEW
	data.a	#112d 	; 324 MID
	data.a	#392d 	; 325 MIN
	data.a	#512d 	; 326 MIT
	data.a	#9ed  	; 327 MOB
	data.a	#11ed 	; 328 MOD
	data.a	#15ed 	; 329 MOE
	data.a	#3ded 	; 330 MOO
	data.a	#41ed 	; 331 MOP
	data.a	#4ded 	; 332 MOS
	data.a	#51ed 	; 333 MOT
	data.a	#5ded 	; 334 MOW
	data.a	#12ad 	; 335 MUD
	data.a	#1ead 	; 336 MUG
	data.a	#36ad 	; 337 MUM
	data.a	#32d  	; 338 MY
	data.a	#82e  	; 339 NAB
	data.a	#1c2e 	; 340 NAG
	data.a	#382e 	; 341 NAN
	data.a	#402e 	; 342 NAP
	data.a	#502e 	; 343 NAT
	data.a	#642e 	; 344 NAY
	data.a	#ae   	; 345 NE
	data.a	#10ae 	; 346 NED
	data.a	#14ae 	; 347 NEE
	data.a	#50ae 	; 348 NET
	data.a	#5cae 	; 349 NEW
	data.a	#92e  	; 350 NIB
	data.a	#312e 	; 351 NIL
	data.a	#412e 	; 352 NIP
	data.a	#512e 	; 353 NIT
	data.a	#1ee  	; 354 NO
	data.a	#9ee  	; 355 NOB
	data.a	#11ee 	; 356 NOD
	data.a	#39ee 	; 357 NON
	data.a	#49ee 	; 358 NOR
	data.a	#51ee 	; 359 NOT
	data.a	#59ee 	; 360 NOV
	data.a	#5dee 	; 361 NOW
	data.a	#2ae  	; 362 NU
	data.a	#3aae 	; 363 NUN
	data.a	#52ae 	; 364 NUT
	data.a	#f    	; 365 O
	data.a	#182f 	; 366 OAF
	data.a	#2c2f 	; 367 OAK
	data.a	#482f 	; 368 OAR
	data.a	#502f 	; 369 OAT
	data.a	#108f 	; 370 ODD
	data.a	#148f 	; 371 ODE
	data.a	#cf   	; 372 OF
	data.a	#18cf 	; 373 OFF
	data.a	#50cf 	; 374 OFT
	data.a	#10f  	; 375 OH
	data.a	#312f 	; 376 OIL
	data.a	#16f  	; 377 OK
	data.a	#118f 	; 378 OLD
	data.a	#1cf  	; 379 ON
	data.a	#15cf 	; 380 ONE
	data.a	#24f  	; 381 OR
	data.a	#a4f  	; 382 ORB
	data.a	#164f 	; 383 ORE
	data.a	#4a4f 	; 384 ORR
	data.a	#26f  	; 385 OS
	data.a	#528f 	; 386 OTT
	data.a	#4aaf 	; 387 OUR
	data.a	#52af 	; 388 OUT
	data.a	#6cf  	; 389 OVA
	data.a	#2ef  	; 390 OW
	data.a	#16ef 	; 391 OWE
	data.a	#32ef 	; 392 OWL
	data.a	#3aef 	; 393 OWN
	data.a	#30f  	; 394 OX
	data.a	#30   	; 395 PA
	data.a	#1030 	; 396 PAD
	data.a	#3030 	; 397 PAL
	data.a	#3430 	; 398 PAM
	data.a	#3830 	; 399 PAN
	data.a	#4030 	; 400 PAP
	data.a	#4830 	; 401 PAR
	data.a	#5030 	; 402 PAT
	data.a	#5c30 	; 403 PAW
	data.a	#6430 	; 404 PAY
	data.a	#4b0  	; 405 PEA
	data.a	#1cb0 	; 406 PEG
	data.a	#38b0 	; 407 PEN
	data.a	#40b0 	; 408 PEP
	data.a	#48b0 	; 409 PER
	data.a	#50b0 	; 410 PET
	data.a	#5cb0 	; 411 PEW
	data.a	#2510 	; 412 PHI
	data.a	#130  	; 413 PI
	data.a	#1530 	; 414 PIE
	data.a	#3930 	; 415 PIN
	data.a	#5130 	; 416 PIT
	data.a	#6590 	; 417 PLY
	data.a	#1f0  	; 418 PO
	data.a	#11f0 	; 419 POD
	data.a	#15f0 	; 420 POE
	data.a	#41f0 	; 421 POP
	data.a	#51f0 	; 422 POT
	data.a	#5df0 	; 423 POW
	data.a	#3e50 	; 424 PRO
	data.a	#6650 	; 425 PRY
	data.a	#ab0  	; 426 PUB
	data.a	#1eb0 	; 427 PUG
	data.a	#3ab0 	; 428 PUN
	data.a	#42b0 	; 429 PUP
	data.a	#52b0 	; 430 PUT
	data.a	#3eb1 	; 431 QUO
	data.a	#1c32 	; 432 RAG
	data.a	#3432 	; 433 RAM
	data.a	#3832 	; 434 RAN
	data.a	#4032 	; 435 RAP
	data.a	#5032 	; 436 RAT
	data.a	#5c32 	; 437 RAW
	data.a	#6432 	; 438 RAY
	data.a	#8b2  	; 439 REB
	data.a	#10b2 	; 440 RED
	data.a	#40b2 	; 441 REP
	data.a	#50b2 	; 442 RET
	data.a	#932  	; 443 RIB
	data.a	#1132 	; 444 RID
	data.a	#1d32 	; 445 RIG
	data.a	#3532 	; 446 RIM
	data.a	#3d32 	; 447 RIO
	data.a	#4132 	; 448 RIP
	data.a	#9f2  	; 449 ROB
	data.a	#11f2 	; 450 ROD
	data.a	#15f2 	; 451 ROE
	data.a	#39f2 	; 452 RON
	data.a	#51f2 	; 453 ROT
	data.a	#5df2 	; 454 ROW
	data.a	#65f2 	; 455 ROY
	data.a	#ab2  	; 456 RUB
	data.a	#16b2 	; 457 RUE
	data.a	#1eb2 	; 458 RUG
	data.a	#36b2 	; 459 RUM
	data.a	#3ab2 	; 460 RUN
	data.a	#1732 	; 461 RYE
	data.a	#c33  	; 462 SAC
	data.a	#1033 	; 463 SAD
	data.a	#1c33 	; 464 SAG
	data.a	#3033 	; 465 SAL
	data.a	#3433 	; 466 SAM
	data.a	#3833 	; 467 SAN
	data.a	#4033 	; 468 SAP
	data.a	#5033 	; 469 SAT
	data.a	#5c33 	; 470 SAW
	data.a	#6433 	; 471 SAY
	data.a	#4b3  	; 472 SEA
	data.a	#cb3  	; 473 SEC
	data.a	#14b3 	; 474 SEE
	data.a	#38b3 	; 475 SEN
	data.a	#50b3 	; 476 SET
	data.a	#5cb3 	; 477 SEW
	data.a	#1513 	; 478 SHE
	data.a	#6513 	; 479 SHY
	data.a	#3933 	; 480 SIN
	data.a	#4133 	; 481 SIP
	data.a	#4933 	; 482 SIR
	data.a	#4d33 	; 483 SIS
	data.a	#5133 	; 484 SIT
	data.a	#2573 	; 485 SKI
	data.a	#6573 	; 486 SKY
	data.a	#6593 	; 487 SLY
	data.a	#1f3  	; 488 SO
	data.a	#9f3  	; 489 SOB
	data.a	#11f3 	; 490 SOD
	data.a	#39f3 	; 491 SON
	data.a	#41f3 	; 492 SOP
	data.a	#5df3 	; 493 SOW
	data.a	#65f3 	; 494 SOY
	data.a	#613  	; 495 SPA
	data.a	#6613 	; 496 SPY
	data.a	#ab3  	; 497 SUB
	data.a	#12b3 	; 498 SUD
	data.a	#16b3 	; 499 SUE
	data.a	#36b3 	; 500 SUM
	data.a	#3ab3 	; 501 SUN
	data.a	#42b3 	; 502 SUP
	data.a	#834  	; 503 TAB
	data.a	#1034 	; 504 TAD
	data.a	#1c34 	; 505 TAG
	data.a	#3834 	; 506 TAN
	data.a	#4034 	; 507 TAP
	data.a	#4834 	; 508 TAR
	data.a	#4b4  	; 509 TEA
	data.a	#10b4 	; 510 TED
	data.a	#14b4 	; 511 TEE
	data.a	#38b4 	; 512 TEN
	data.a	#1514 	; 513 THE
	data.a	#6514 	; 514 THY
	data.a	#d34  	; 515 TIC
	data.a	#1534 	; 516 TIE
	data.a	#3534 	; 517 TIM
	data.a	#3934 	; 518 TIN
	data.a	#4134 	; 519 TIP
	data.a	#1f4  	; 520 TO
	data.a	#15f4 	; 521 TOE
	data.a	#1df4 	; 522 TOG
	data.a	#35f4 	; 523 TOM
	data.a	#39f4 	; 524 TON
	data.a	#3df4 	; 525 TOO
	data.a	#41f4 	; 526 TOP
	data.a	#5df4 	; 527 TOW
	data.a	#65f4 	; 528 TOY
	data.a	#6654 	; 529 TRY
	data.a	#ab4  	; 530 TUB
	data.a	#1eb4 	; 531 TUG
	data.a	#36b4 	; 532 TUM
	data.a	#3ab4 	; 533 TUN
	data.a	#3ef4 	; 534 TWO
	data.a	#1d5  	; 535 UN
	data.a	#215  	; 536 UP
	data.a	#275  	; 537 US
	data.a	#1675 	; 538 USE
	data.a	#3836 	; 539 VAN
	data.a	#5036 	; 540 VAT
	data.a	#50b6 	; 541 VET
	data.a	#1536 	; 542 VIE
	data.a	#1037 	; 543 WAD
	data.a	#1c37 	; 544 WAG
	data.a	#4837 	; 545 WAR
	data.a	#4c37 	; 546 WAS
	data.a	#6437 	; 547 WAY
	data.a	#b7   	; 548 WE
	data.a	#8b7  	; 549 WEB
	data.a	#10b7 	; 550 WED
	data.a	#14b7 	; 551 WEE
	data.a	#50b7 	; 552 WET
	data.a	#3d17 	; 553 WHO
	data.a	#6517 	; 554 WHY
	data.a	#3937 	; 555 WIN
	data.a	#5137 	; 556 WIT
	data.a	#2df7 	; 557 WOK
	data.a	#39f7 	; 558 WON
	data.a	#3df7 	; 559 WOO
	data.a	#5df7 	; 560 WOW
	data.a	#6657 	; 561 WRY
	data.a	#2b7  	; 562 WU
	data.a	#3439 	; 563 YAM
	data.a	#4039 	; 564 YAP
	data.a	#5c39 	; 565 YAW
	data.a	#b9   	; 566 YE
	data.a	#4b9  	; 567 YEA
	data.a	#4cb9 	; 568 YES
	data.a	#50b9 	; 569 YET
	data.a	#55f9 	; 570 YOU
	data.a	#21441	; 571 ABED
	data.a	#61441	; 572 ABEL
	data.a	#a1441	; 573 ABET
	data.a	#2b041	; 574 ABLE
	data.a	#a5441	; 575 ABUT
	data.a	#2a061	; 576 ACHE
	data.a	#22461	; 577 ACID
	data.a	#2b461	; 578 ACME
	data.a	#2c861	; 579 ACRE
	data.a	#d061 	; 580 ACTA
	data.a	#9d061	; 581 ACTS
	data.a	#68481	; 582 ADAM
	data.a	#99081	; 583 ADDS
	data.a	#71481	; 584 ADEN
	data.a	#904c1	; 585 AFAR
	data.a	#7c8c1	; 586 AFRO
	data.a	#294e1	; 587 AGEE
	data.a	#69501	; 588 AHEM
	data.a	#cbd01	; 589 AHOY
	data.a	#9121 	; 590 AIDA
	data.a	#29121	; 591 AIDE
	data.a	#99121	; 592 AIDS
	data.a	#cc921	; 593 AIRY
	data.a	#90541	; 594 AJAR
	data.a	#72561	; 595 AKIN
	data.a	#70581	; 596 ALAN
	data.a	#19581	; 597 ALEC
	data.a	#9d81 	; 598 ALGA
	data.a	#a581 	; 599 ALIA
	data.a	#cb181	; 600 ALLY
	data.a	#b581 	; 601 ALMA
	data.a	#2bd81	; 602 ALOE
	data.a	#7cd81	; 603 ALSO
	data.a	#7d181	; 604 ALTO
	data.a	#6d581	; 605 ALUM
	data.a	#d981 	; 606 ALVA
	data.a	#715a1	; 607 AMEN
	data.a	#995a1	; 608 AMES
	data.a	#225a1	; 609 AMID
	data.a	#7b5a1	; 610 AMMO
	data.a	#5bda1	; 611 AMOK
	data.a	#9bda1	; 612 AMOS
	data.a	#c9a1 	; 613 AMRA
	data.a	#c91c1	; 614 ANDY
	data.a	#b95c1	; 615 ANEW
	data.a	#b9c1 	; 616 ANNA
	data.a	#2b9c1	; 617 ANNE
	data.a	#2d1c1	; 618 ANTE
	data.a	#4d1c1	; 619 ANTI
	data.a	#d621 	; 620 AQUA
	data.a	#10641	; 621 ARAB
	data.a	#40e41	; 622 ARCH
	data.a	#9641 	; 623 AREA
	data.a	#79e41	; 624 ARGO
	data.a	#22641	; 625 ARID
	data.a	#cb641	; 626 ARMY
	data.a	#9d241	; 627 ARTS
	data.a	#cd241	; 628 ARTY
	data.a	#a661 	; 629 ASIA
	data.a	#9ae61	; 630 ASKS
	data.a	#6be81	; 631 ATOM
	data.a	#a3aa1	; 632 AUNT
	data.a	#caa1 	; 633 AURA
	data.a	#7d2a1	; 634 AUTO
	data.a	#916c1	; 635 AVER
	data.a	#226c1	; 636 AVID
	data.a	#9a6c1	; 637 AVIS
	data.a	#73ec1	; 638 AVON
	data.a	#bbec1	; 639 AVOW
	data.a	#c86e1	; 640 AWAY
	data.a	#ccae1	; 641 AWRY
	data.a	#28822	; 642 BABE
	data.a	#c8822	; 643 BABY
	data.a	#40c22	; 644 BACH
	data.a	#58c22	; 645 BACK
	data.a	#29022	; 646 BADE
	data.a	#62422	; 647 BAIL
	data.a	#a2422	; 648 BAIT
	data.a	#2ac22	; 649 BAKE
	data.a	#23022	; 650 BALD
	data.a	#2b022	; 651 BALE
	data.a	#4b022	; 652 BALI
	data.a	#5b022	; 653 BALK
	data.a	#63022	; 654 BALL
	data.a	#6b022	; 655 BALM
	data.a	#23822	; 656 BAND
	data.a	#2b822	; 657 BANE
	data.a	#3b822	; 658 BANG
	data.a	#5b822	; 659 BANK
	data.a	#14822	; 660 BARB
	data.a	#24822	; 661 BARD
	data.a	#2c822	; 662 BARE
	data.a	#5c822	; 663 BARK
	data.a	#74822	; 664 BARN
	data.a	#94822	; 665 BARR
	data.a	#2cc22	; 666 BASE
	data.a	#44c22	; 667 BASH
	data.a	#5cc22	; 668 BASK
	data.a	#9cc22	; 669 BASS
	data.a	#2d022	; 670 BATE
	data.a	#45022	; 671 BATH
	data.a	#25c22	; 672 BAWD
	data.a	#65c22	; 673 BAWL
	data.a	#204a2	; 674 BEAD
	data.a	#584a2	; 675 BEAK
	data.a	#684a2	; 676 BEAM
	data.a	#704a2	; 677 BEAN
	data.a	#904a2	; 678 BEAR
	data.a	#a04a2	; 679 BEAT
	data.a	#a84a2	; 680 BEAU
	data.a	#58ca2	; 681 BECK
	data.a	#314a2	; 682 BEEF
	data.a	#714a2	; 683 BEEN
	data.a	#914a2	; 684 BEER
	data.a	#a14a2	; 685 BEET
	data.a	#b0a2 	; 686 BELA
	data.a	#630a2	; 687 BELL
	data.a	#a30a2	; 688 BELT
	data.a	#238a2	; 689 BEND
	data.a	#a38a2	; 690 BENT
	data.a	#3c8a2	; 691 BERG
	data.a	#748a2	; 692 BERN
	data.a	#a48a2	; 693 BERT
	data.a	#9cca2	; 694 BESS
	data.a	#a4ca2	; 695 BEST
	data.a	#d0a2 	; 696 BETA
	data.a	#450a2	; 697 BETH
	data.a	#cbd02	; 698 BHOY
	data.a	#98522	; 699 BIAS
	data.a	#29122	; 700 BIDE
	data.a	#71522	; 701 BIEN
	data.a	#2b122	; 702 BILE
	data.a	#5b122	; 703 BILK
	data.a	#63122	; 704 BILL
	data.a	#23922	; 705 BIND
	data.a	#3b922	; 706 BING
	data.a	#24922	; 707 BIRD
	data.a	#2d122	; 708 BITE
	data.a	#9d122	; 709 BITS
	data.a	#10582	; 710 BLAB
	data.a	#a0582	; 711 BLAT
	data.a	#21582	; 712 BLED
	data.a	#b9582	; 713 BLEW
	data.a	#13d82	; 714 BLOB
	data.a	#1bd82	; 715 BLOC
	data.a	#a3d82	; 716 BLOT
	data.a	#bbd82	; 717 BLOW
	data.a	#2d582	; 718 BLUE
	data.a	#6d582	; 719 BLUM
	data.a	#95582	; 720 BLUR
	data.a	#905e2	; 721 BOAR
	data.a	#a05e2	; 722 BOAT
	data.a	#8de2 	; 723 BOCA
	data.a	#58de2	; 724 BOCK
	data.a	#291e2	; 725 BODE
	data.a	#c91e2	; 726 BODY
	data.a	#c9de2	; 727 BOGY
	data.a	#921e2	; 728 BOHR
	data.a	#625e2	; 729 BOIL
	data.a	#231e2	; 730 BOLD
	data.a	#7b1e2	; 731 BOLO
	data.a	#a31e2	; 732 BOLT
	data.a	#135e2	; 733 BOMB
	data.a	#b9e2 	; 734 BONA
	data.a	#239e2	; 735 BOND
	data.a	#2b9e2	; 736 BONE
	data.a	#3b9e2	; 737 BONG
	data.a	#739e2	; 738 BONN
	data.a	#cb9e2	; 739 BONY
	data.a	#5bde2	; 740 BOOK
	data.a	#6bde2	; 741 BOOM
	data.a	#73de2	; 742 BOON
	data.a	#a3de2	; 743 BOOT
	data.a	#2c9e2	; 744 BORE
	data.a	#3c9e2	; 745 BORG
	data.a	#749e2	; 746 BORN
	data.a	#2cde2	; 747 BOSE
	data.a	#9cde2	; 748 BOSS
	data.a	#451e2	; 749 BOTH
	data.a	#a55e2	; 750 BOUT
	data.a	#65de2	; 751 BOWL
	data.a	#265e2	; 752 BOYD
	data.a	#20642	; 753 BRAD
	data.a	#28642	; 754 BRAE
	data.a	#38642	; 755 BRAG
	data.a	#70642	; 756 BRAN
	data.a	#c8642	; 757 BRAY
	data.a	#21642	; 758 BRED
	data.a	#b9642	; 759 BREW
	data.a	#3a642	; 760 BRIG
	data.a	#6a642	; 761 BRIM
	data.a	#bbe42	; 762 BROW
	data.a	#58ea2	; 763 BUCK
	data.a	#212a2	; 764 BUDD
	data.a	#31aa2	; 765 BUFF
	data.a	#132a2	; 766 BULB
	data.a	#5b2a2	; 767 BULK
	data.a	#632a2	; 768 BULL
	data.a	#5baa2	; 769 BUNK
	data.a	#a3aa2	; 770 BUNT
	data.a	#cbea2	; 771 BUOY
	data.a	#3caa2	; 772 BURG
	data.a	#64aa2	; 773 BURL
	data.a	#74aa2	; 774 BURN
	data.a	#94aa2	; 775 BURR
	data.a	#a4aa2	; 776 BURT
	data.a	#ccaa2	; 777 BURY
	data.a	#44ea2	; 778 BUSH
	data.a	#9cea2	; 779 BUSS
	data.a	#a4ea2	; 780 BUST
	data.a	#ccea2	; 781 BUSY
	data.a	#2d322	; 782 BYTE
	data.a	#c9023	; 783 CADY
	data.a	#29823	; 784 CAFE
	data.a	#29c23	; 785 CAGE
	data.a	#72423	; 786 CAIN
	data.a	#2ac23	; 787 CAKE
	data.a	#33023	; 788 CALF
	data.a	#63023	; 789 CALL
	data.a	#6b023	; 790 CALM
	data.a	#2b423	; 791 CAME
	data.a	#2b823	; 792 CANE
	data.a	#a3823	; 793 CANT
	data.a	#24823	; 794 CARD
	data.a	#2c823	; 795 CARE
	data.a	#64823	; 796 CARL
	data.a	#94823	; 797 CARR
	data.a	#a4823	; 798 CART
	data.a	#2cc23	; 799 CASE
	data.a	#44c23	; 800 CASH
	data.a	#5cc23	; 801 CASK
	data.a	#a4c23	; 802 CAST
	data.a	#2d823	; 803 CAVE
	data.a	#624a3	; 804 CEIL
	data.a	#630a3	; 805 CELL
	data.a	#a38a3	; 806 CENT
	data.a	#748a3	; 807 CERN
	data.a	#20503	; 808 CHAD
	data.a	#90503	; 809 CHAR
	data.a	#a0503	; 810 CHAT
	data.a	#b8503	; 811 CHAW
	data.a	#31503	; 812 CHEF
	data.a	#71503	; 813 CHEN
	data.a	#b9503	; 814 CHEW
	data.a	#1a503	; 815 CHIC
	data.a	#72503	; 816 CHIN
	data.a	#abd03	; 817 CHOU
	data.a	#bbd03	; 818 CHOW
	data.a	#15503	; 819 CHUB
	data.a	#3d503	; 820 CHUG
	data.a	#6d503	; 821 CHUM
	data.a	#2d123	; 822 CITE
	data.a	#cd123	; 823 CITY
	data.a	#20583	; 824 CLAD
	data.a	#68583	; 825 CLAM
	data.a	#70583	; 826 CLAN
	data.a	#b8583	; 827 CLAW
	data.a	#c8583	; 828 CLAY
	data.a	#23d83	; 829 CLOD
	data.a	#3bd83	; 830 CLOG
	data.a	#a3d83	; 831 CLOT
	data.a	#15583	; 832 CLUB
	data.a	#2d583	; 833 CLUE
	data.a	#605e3	; 834 COAL
	data.a	#a05e3	; 835 COAT
	data.a	#8de3 	; 836 COCA
	data.a	#58de3	; 837 COCK
	data.a	#78de3	; 838 COCO
	data.a	#91e3 	; 839 CODA
	data.a	#291e3	; 840 CODE
	data.a	#c91e3	; 841 CODY
	data.a	#215e3	; 842 COED
	data.a	#625e3	; 843 COIL
	data.a	#725e3	; 844 COIN
	data.a	#2ade3	; 845 COKE
	data.a	#b1e3 	; 846 COLA
	data.a	#231e3	; 847 COLD
	data.a	#a31e3	; 848 COLT
	data.a	#b5e3 	; 849 COMA
	data.a	#135e3	; 850 COMB
	data.a	#2b5e3	; 851 COME
	data.a	#5bde3	; 852 COOK
	data.a	#63de3	; 853 COOL
	data.a	#73de3	; 854 COON
	data.a	#a3de3	; 855 COOT
	data.a	#249e3	; 856 CORD
	data.a	#2c9e3	; 857 CORE
	data.a	#5c9e3	; 858 CORK
	data.a	#749e3	; 859 CORN
	data.a	#a4de3	; 860 COST
	data.a	#2d9e3	; 861 COVE
	data.a	#65de3	; 862 COWL
	data.a	#10643	; 863 CRAB
	data.a	#38643	; 864 CRAG
	data.a	#68643	; 865 CRAM
	data.a	#c8643	; 866 CRAY
	data.a	#b9643	; 867 CREW
	data.a	#12643	; 868 CRIB
	data.a	#bbe43	; 869 CROW
	data.a	#25643	; 870 CRUD
	data.a	#8aa3 	; 871 CUBA
	data.a	#28aa3	; 872 CUBE
	data.a	#31aa3	; 873 CUFF
	data.a	#632a3	; 874 CULL
	data.a	#a32a3	; 875 CULT
	data.a	#cbaa3	; 876 CUNY
	data.a	#14aa3	; 877 CURB
	data.a	#24aa3	; 878 CURD
	data.a	#2caa3	; 879 CURE
	data.a	#64aa3	; 880 CURL
	data.a	#a4aa3	; 881 CURT
	data.a	#9d2a3	; 882 CUTS
	data.a	#29024	; 883 DADE
	data.a	#2b024	; 884 DALE
	data.a	#2b424	; 885 DAME
	data.a	#b824 	; 886 DANA
	data.a	#2b824	; 887 DANE
	data.a	#3b824	; 888 DANG
	data.a	#5b824	; 889 DANK
	data.a	#2c824	; 890 DARE
	data.a	#5c824	; 891 DARK
	data.a	#74824	; 892 DARN
	data.a	#a4824	; 893 DART
	data.a	#44c24	; 894 DASH
	data.a	#d024 	; 895 DATA
	data.a	#2d024	; 896 DATE
	data.a	#2d824	; 897 DAVE
	data.a	#cd824	; 898 DAVY
	data.a	#75c24	; 899 DAWN
	data.a	#9e424	; 900 DAYS
	data.a	#204a4	; 901 DEAD
	data.a	#304a4	; 902 DEAF
	data.a	#604a4	; 903 DEAL
	data.a	#704a4	; 904 DEAN
	data.a	#904a4	; 905 DEAR
	data.a	#a08a4	; 906 DEBT
	data.a	#58ca4	; 907 DECK
	data.a	#214a4	; 908 DEED
	data.a	#694a4	; 909 DEEM
	data.a	#914a4	; 910 DEER
	data.a	#a18a4	; 911 DEFT
	data.a	#c98a4	; 912 DEFY
	data.a	#630a4	; 913 DELL
	data.a	#a38a4	; 914 DENT
	data.a	#cb8a4	; 915 DENY
	data.a	#5cca4	; 916 DESK
	data.a	#60524	; 917 DIAL
	data.a	#28d24	; 918 DICE
	data.a	#21524	; 919 DIED
	data.a	#a1524	; 920 DIET
	data.a	#2b524	; 921 DIME
	data.a	#2b924	; 922 DINE
	data.a	#3b924	; 923 DING
	data.a	#a3924	; 924 DINT
	data.a	#2c924	; 925 DIRE
	data.a	#a4924	; 926 DIRT
	data.a	#1cd24	; 927 DISC
	data.a	#44d24	; 928 DISH
	data.a	#5cd24	; 929 DISK
	data.a	#2d924	; 930 DIVE
	data.a	#58de4	; 931 DOCK
	data.a	#995e4	; 932 DOES
	data.a	#2b1e4	; 933 DOLE
	data.a	#631e4	; 934 DOLL
	data.a	#a31e4	; 935 DOLT
	data.a	#2b5e4	; 936 DOME
	data.a	#2b9e4	; 937 DONE
	data.a	#6bde4	; 938 DOOM
	data.a	#93de4	; 939 DOOR
	data.a	#c9e4 	; 940 DORA
	data.a	#2cde4	; 941 DOSE
	data.a	#2d1e4	; 942 DOTE
	data.a	#3d5e4	; 943 DOUG
	data.a	#955e4	; 944 DOUR
	data.a	#2d9e4	; 945 DOVE
	data.a	#75de4	; 946 DOWN
	data.a	#10644	; 947 DRAB
	data.a	#38644	; 948 DRAG
	data.a	#68644	; 949 DRAM
	data.a	#b8644	; 950 DRAW
	data.a	#b9644	; 951 DREW
	data.a	#15644	; 952 DRUB
	data.a	#3d644	; 953 DRUG
	data.a	#6d644	; 954 DRUM
	data.a	#606a4	; 955 DUAL
	data.a	#58ea4	; 956 DUCK
	data.a	#a0ea4	; 957 DUCT
	data.a	#616a4	; 958 DUEL
	data.a	#a16a4	; 959 DUET
	data.a	#2aea4	; 960 DUKE
	data.a	#632a4	; 961 DULL
	data.a	#136a4	; 962 DUMB
	data.a	#2baa4	; 963 DUNE
	data.a	#5baa4	; 964 DUNK
	data.a	#5cea4	; 965 DUSK
	data.a	#a4ea4	; 966 DUST
	data.a	#cd2a4	; 967 DUTY
	data.a	#40c25	; 968 EACH
	data.a	#64825	; 969 EARL
	data.a	#74825	; 970 EARN
	data.a	#2cc25	; 971 EASE
	data.a	#a4c25	; 972 EAST
	data.a	#ccc25	; 973 EASY
	data.a	#71445	; 974 EBEN
	data.a	#7a065	; 975 ECHO
	data.a	#c9085	; 976 EDDY
	data.a	#71485	; 977 EDEN
	data.a	#29c85	; 978 EDGE
	data.a	#c9c85	; 979 EDGY
	data.a	#a2485	; 980 EDIT
	data.a	#b885 	; 981 EDNA
	data.a	#704e5	; 982 EGAN
	data.a	#70585	; 983 ELAN
	data.a	#8985 	; 984 ELBA
	data.a	#b185 	; 985 ELLA
	data.a	#2cd85	; 986 ELSE
	data.a	#625a5	; 987 EMIL
	data.a	#a25a5	; 988 EMIT
	data.a	#b5a5 	; 989 EMMA
	data.a	#991c5	; 990 ENDS
	data.a	#1a645	; 991 ERIC
	data.a	#9be45	; 992 EROS
	data.a	#716c5	; 993 EVEN
	data.a	#916c5	; 994 EVER
	data.a	#626c5	; 995 EVIL
	data.a	#21725	; 996 EYED
	data.a	#28c26	; 997 FACE
	data.a	#a0c26	; 998 FACT
	data.a	#29026	; 999 FADE
	data.a	#62426	;1000 FAIL
	data.a	#72426	;1001 FAIN
	data.a	#92426	;1002 FAIR
	data.a	#2ac26	;1003 FAKE
	data.a	#63026	;1004 FALL
	data.a	#2b426	;1005 FAME
	data.a	#3b826	;1006 FANG
	data.a	#6c826	;1007 FARM
	data.a	#a4c26	;1008 FAST
	data.a	#2d026	;1009 FATE
	data.a	#75c26	;1010 FAWN
	data.a	#904a6	;1011 FEAR
	data.a	#a04a6	;1012 FEAT
	data.a	#214a6	;1013 FEED
	data.a	#614a6	;1014 FEEL
	data.a	#a14a6	;1015 FEET
	data.a	#630a6	;1016 FELL
	data.a	#a30a6	;1017 FELT
	data.a	#238a6	;1018 FEND
	data.a	#748a6	;1019 FERN
	data.a	#a4ca6	;1020 FEST
	data.a	#254a6	;1021 FEUD
	data.a	#31526	;1022 FIEF
	data.a	#99d26	;1023 FIGS
	data.a	#2b126	;1024 FILE
	data.a	#63126	;1025 FILL
	data.a	#6b126	;1026 FILM
	data.a	#23926	;1027 FIND
	data.a	#2b926	;1028 FINE
	data.a	#5b926	;1029 FINK
	data.a	#2c926	;1030 FIRE
	data.a	#6c926	;1031 FIRM
	data.a	#44d26	;1032 FISH
	data.a	#5cd26	;1033 FISK
	data.a	#a4d26	;1034 FIST
	data.a	#9d126	;1035 FITS
	data.a	#2d926	;1036 FIVE
	data.a	#38586	;1037 FLAG
	data.a	#58586	;1038 FLAK
	data.a	#68586	;1039 FLAM
	data.a	#a0586	;1040 FLAT
	data.a	#b8586	;1041 FLAW
	data.a	#9586 	;1042 FLEA
	data.a	#21586	;1043 FLED
	data.a	#b9586	;1044 FLEW
	data.a	#a2586	;1045 FLIT
	data.a	#1bd86	;1046 FLOC
	data.a	#3bd86	;1047 FLOG
	data.a	#bbd86	;1048 FLOW
	data.a	#15586	;1049 FLUB
	data.a	#2d586	;1050 FLUE
	data.a	#605e6	;1051 FOAL
	data.a	#685e6	;1052 FOAM
	data.a	#c9de6	;1053 FOGY
	data.a	#625e6	;1054 FOIL
	data.a	#231e6	;1055 FOLD
	data.a	#5b1e6	;1056 FOLK
	data.a	#239e6	;1057 FOND
	data.a	#a39e6	;1058 FONT
	data.a	#23de6	;1059 FOOD
	data.a	#63de6	;1060 FOOL
	data.a	#a3de6	;1061 FOOT
	data.a	#249e6	;1062 FORD
	data.a	#2c9e6	;1063 FORE
	data.a	#5c9e6	;1064 FORK
	data.a	#6c9e6	;1065 FORM
	data.a	#a49e6	;1066 FORT
	data.a	#9cde6	;1067 FOSS
	data.a	#655e6	;1068 FOUL
	data.a	#955e6	;1069 FOUR
	data.a	#65de6	;1070 FOWL
	data.a	#a8646	;1071 FRAU
	data.a	#c8646	;1072 FRAY
	data.a	#21646	;1073 FRED
	data.a	#29646	;1074 FREE
	data.a	#a1646	;1075 FRET
	data.a	#c9646	;1076 FREY
	data.a	#3be46	;1077 FROG
	data.a	#6be46	;1078 FROM
	data.a	#616a6	;1079 FUEL
	data.a	#632a6	;1080 FULL
	data.a	#2b6a6	;1081 FUME
	data.a	#23aa6	;1082 FUND
	data.a	#5baa6	;1083 FUNK
	data.a	#ccaa6	;1084 FURY
	data.a	#2cea6	;1085 FUSE
	data.a	#9cea6	;1086 FUSS
	data.a	#31827	;1087 GAFF
	data.a	#29c27	;1088 GAGE
	data.a	#62427	;1089 GAIL
	data.a	#72427	;1090 GAIN
	data.a	#a2427	;1091 GAIT
	data.a	#b027 	;1092 GALA
	data.a	#2b027	;1093 GALE
	data.a	#63027	;1094 GALL
	data.a	#a3027	;1095 GALT
	data.a	#2b427	;1096 GAME
	data.a	#3b827	;1097 GANG
	data.a	#14827	;1098 GARB
	data.a	#cc827	;1099 GARY
	data.a	#44c27	;1100 GASH
	data.a	#2d027	;1101 GATE
	data.a	#65427	;1102 GAUL
	data.a	#95427	;1103 GAUR
	data.a	#2d827	;1104 GAVE
	data.a	#5dc27	;1105 GAWK
	data.a	#904a7	;1106 GEAR
	data.a	#230a7	;1107 GELD
	data.a	#2b8a7	;1108 GENE
	data.a	#a38a7	;1109 GENT
	data.a	#6c8a7	;1110 GERM
	data.a	#9d0a7	;1111 GETS
	data.a	#28927	;1112 GIBE
	data.a	#a1927	;1113 GIFT
	data.a	#23127	;1114 GILD
	data.a	#63127	;1115 GILL
	data.a	#a3127	;1116 GILT
	data.a	#b927 	;1117 GINA
	data.a	#24927	;1118 GIRD
	data.a	#64927	;1119 GIRL
	data.a	#a4d27	;1120 GIST
	data.a	#2d927	;1121 GIVE
	data.a	#20587	;1122 GLAD
	data.a	#29587	;1123 GLEE
	data.a	#71587	;1124 GLEN
	data.a	#12587	;1125 GLIB
	data.a	#13d87	;1126 GLOB
	data.a	#6bd87	;1127 GLOM
	data.a	#bbd87	;1128 GLOW
	data.a	#2d587	;1129 GLUE
	data.a	#6d587	;1130 GLUM
	data.a	#a5587	;1131 GLUT
	data.a	#205e7	;1132 GOAD
	data.a	#605e7	;1133 GOAL
	data.a	#a05e7	;1134 GOAT
	data.a	#915e7	;1135 GOER
	data.a	#995e7	;1136 GOES
	data.a	#231e7	;1137 GOLD
	data.a	#331e7	;1138 GOLF
	data.a	#2b9e7	;1139 GONE
	data.a	#3b9e7	;1140 GONG
	data.a	#23de7	;1141 GOOD
	data.a	#33de7	;1142 GOOF
	data.a	#2c9e7	;1143 GORE
	data.a	#cc9e7	;1144 GORY
	data.a	#44de7	;1145 GOSH
	data.a	#a55e7	;1146 GOUT
	data.a	#75de7	;1147 GOWN
	data.a	#10647	;1148 GRAB
	data.a	#20647	;1149 GRAD
	data.a	#c8647	;1150 GRAY
	data.a	#39647	;1151 GREG
	data.a	#b9647	;1152 GREW
	data.a	#c9647	;1153 GREY
	data.a	#22647	;1154 GRID
	data.a	#6a647	;1155 GRIM
	data.a	#72647	;1156 GRIN
	data.a	#a2647	;1157 GRIT
	data.a	#bbe47	;1158 GROW
	data.a	#15647	;1159 GRUB
	data.a	#332a7	;1160 GULF
	data.a	#632a7	;1161 GULL
	data.a	#5baa7	;1162 GUNK
	data.a	#acaa7	;1163 GURU
	data.a	#44ea7	;1164 GUSH
	data.a	#a4ea7	;1165 GUST
	data.a	#716e7	;1166 GWEN
	data.a	#766e7	;1167 GWYN
	data.a	#38428	;1168 HAAG
	data.a	#98428	;1169 HAAS
	data.a	#58c28	;1170 HACK
	data.a	#62428	;1171 HAIL
	data.a	#92428	;1172 HAIR
	data.a	#2b028	;1173 HALE
	data.a	#33028	;1174 HALF
	data.a	#63028	;1175 HALL
	data.a	#7b028	;1176 HALO
	data.a	#a3028	;1177 HALT
	data.a	#23828	;1178 HAND
	data.a	#3b828	;1179 HANG
	data.a	#5b828	;1180 HANK
	data.a	#9b828	;1181 HANS
	data.a	#24828	;1182 HARD
	data.a	#5c828	;1183 HARK
	data.a	#6c828	;1184 HARM
	data.a	#a4828	;1185 HART
	data.a	#44c28	;1186 HASH
	data.a	#a4c28	;1187 HAST
	data.a	#2d028	;1188 HATE
	data.a	#45028	;1189 HATH
	data.a	#65428	;1190 HAUL
	data.a	#2d828	;1191 HAVE
	data.a	#5dc28	;1192 HAWK
	data.a	#9e428	;1193 HAYS
	data.a	#204a8	;1194 HEAD
	data.a	#604a8	;1195 HEAL
	data.a	#904a8	;1196 HEAR
	data.a	#a04a8	;1197 HEAT
	data.a	#288a8	;1198 HEBE
	data.a	#58ca8	;1199 HECK
	data.a	#214a8	;1200 HEED
	data.a	#614a8	;1201 HEEL
	data.a	#a18a8	;1202 HEFT
	data.a	#230a8	;1203 HELD
	data.a	#630a8	;1204 HELL
	data.a	#6b0a8	;1205 HELM
	data.a	#148a8	;1206 HERB
	data.a	#248a8	;1207 HERD
	data.a	#2c8a8	;1208 HERE
	data.a	#7c8a8	;1209 HERO
	data.a	#9c8a8	;1210 HERS
	data.a	#9cca8	;1211 HESS
	data.a	#75ca8	;1212 HEWN
	data.a	#58d28	;1213 HICK
	data.a	#29128	;1214 HIDE
	data.a	#41d28	;1215 HIGH
	data.a	#2ad28	;1216 HIKE
	data.a	#63128	;1217 HILL
	data.a	#a3128	;1218 HILT
	data.a	#23928	;1219 HIND
	data.a	#a3928	;1220 HINT
	data.a	#2c928	;1221 HIRE
	data.a	#9cd28	;1222 HISS
	data.a	#2d928	;1223 HIVE
	data.a	#789e8	;1224 HOBO
	data.a	#58de8	;1225 HOCK
	data.a	#319e8	;1226 HOFF
	data.a	#231e8	;1227 HOLD
	data.a	#2b1e8	;1228 HOLE
	data.a	#6b1e8	;1229 HOLM
	data.a	#a31e8	;1230 HOLT
	data.a	#2b5e8	;1231 HOME
	data.a	#2b9e8	;1232 HONE
	data.a	#5b9e8	;1233 HONK
	data.a	#23de8	;1234 HOOD
	data.a	#33de8	;1235 HOOF
	data.a	#5bde8	;1236 HOOK
	data.a	#a3de8	;1237 HOOT
	data.a	#749e8	;1238 HORN
	data.a	#2cde8	;1239 HOSE
	data.a	#a4de8	;1240 HOST
	data.a	#955e8	;1241 HOUR
	data.a	#2d9e8	;1242 HOVE
	data.a	#2dde8	;1243 HOWE
	data.a	#65de8	;1244 HOWL
	data.a	#a65e8	;1245 HOYT
	data.a	#58ea8	;1246 HUCK
	data.a	#216a8	;1247 HUED
	data.a	#31aa8	;1248 HUFF
	data.a	#29ea8	;1249 HUGE
	data.a	#41ea8	;1250 HUGH
	data.a	#79ea8	;1251 HUGO
	data.a	#5b2a8	;1252 HULK
	data.a	#632a8	;1253 HULL
	data.a	#5baa8	;1254 HUNK
	data.a	#a3aa8	;1255 HUNT
	data.a	#24aa8	;1256 HURD
	data.a	#64aa8	;1257 HURL
	data.a	#a4aa8	;1258 HURT
	data.a	#44ea8	;1259 HUSH
	data.a	#29328	;1260 HYDE
	data.a	#73728	;1261 HYMN
	data.a	#9a449	;1262 IBIS
	data.a	#73c69	;1263 ICON
	data.a	#9489 	;1264 IDEA
	data.a	#2b089	;1265 IDLE
	data.a	#c98c9	;1266 IFFY
	data.a	#8dc9 	;1267 INCA
	data.a	#40dc9	;1268 INCH
	data.a	#7d1c9	;1269 INTO
	data.a	#9b9e9	;1270 IONS
	data.a	#d1e9 	;1271 IOTA
	data.a	#dde9 	;1272 IOWA
	data.a	#9a649	;1273 IRIS
	data.a	#b649 	;1274 IRMA
	data.a	#73e49	;1275 IRON
	data.a	#2b269	;1276 ISLE
	data.a	#40e89	;1277 ITCH
	data.a	#69689	;1278 ITEM
	data.a	#706c9	;1279 IVAN
	data.a	#58c2a	;1280 JACK
	data.a	#2902a	;1281 JADE
	data.a	#6242a	;1282 JAIL
	data.a	#2ac2a	;1283 JAKE
	data.a	#2b82a	;1284 JANE
	data.a	#d82a 	;1285 JAVA
	data.a	#704aa	;1286 JEAN
	data.a	#318aa	;1287 JEFF
	data.a	#5c8aa	;1288 JERK
	data.a	#9ccaa	;1289 JESS
	data.a	#a4caa	;1290 JEST
	data.a	#2892a	;1291 JIBE
	data.a	#6312a	;1292 JILL
	data.a	#a312a	;1293 JILT
	data.a	#2d92a	;1294 JIVE
	data.a	#705ea	;1295 JOAN
	data.a	#989ea	;1296 JOBS
	data.a	#58dea	;1297 JOCK
	data.a	#615ea	;1298 JOEL
	data.a	#c95ea	;1299 JOEY
	data.a	#721ea	;1300 JOHN
	data.a	#725ea	;1301 JOIN
	data.a	#2adea	;1302 JOKE
	data.a	#a31ea	;1303 JOLT
	data.a	#2d9ea	;1304 JOVE
	data.a	#212aa	;1305 JUDD
	data.a	#292aa	;1306 JUDE
	data.a	#792aa	;1307 JUDO
	data.a	#c92aa	;1308 JUDY
	data.a	#aaaaa	;1309 JUJU
	data.a	#2aeaa	;1310 JUKE
	data.a	#cb2aa	;1311 JULY
	data.a	#2baaa	;1312 JUNE
	data.a	#5baaa	;1313 JUNK
	data.a	#7baaa	;1314 JUNO
	data.a	#ccaaa	;1315 JURY
	data.a	#a4eaa	;1316 JUST
	data.a	#2d2aa	;1317 JUTE
	data.a	#7202b	;1318 KAHN
	data.a	#2b02b	;1319 KALE
	data.a	#2b82b	;1320 KANE
	data.a	#a382b	;1321 KANT
	data.a	#6482b	;1322 KARL
	data.a	#2d02b	;1323 KATE
	data.a	#614ab	;1324 KEEL
	data.a	#714ab	;1325 KEEN
	data.a	#7b8ab	;1326 KENO
	data.a	#a38ab	;1327 KENT
	data.a	#748ab	;1328 KERN
	data.a	#948ab	;1329 KERR
	data.a	#9e4ab	;1330 KEYS
	data.a	#58d2b	;1331 KICK
	data.a	#6312b	;1332 KILL
	data.a	#2392b	;1333 KIND
	data.a	#3b92b	;1334 KING
	data.a	#5c92b	;1335 KIRK
	data.a	#9cd2b	;1336 KISS
	data.a	#2d12b	;1337 KITE
	data.a	#7058b	;1338 KLAN
	data.a	#295cb	;1339 KNEE
	data.a	#b95cb	;1340 KNEW
	data.a	#a25cb	;1341 KNIT
	data.a	#13dcb	;1342 KNOB
	data.a	#a3dcb	;1343 KNOT
	data.a	#bbdcb	;1344 KNOW
	data.a	#40deb	;1345 KOCH
	data.a	#3b9eb	;1346 KONG
	data.a	#792ab	;1347 KUDO
	data.a	#24aab	;1348 KURD
	data.a	#a4aab	;1349 KURT
	data.a	#2b32b	;1350 KYLE
	data.a	#28c2c	;1351 LACE
	data.a	#58c2c	;1352 LACK
	data.a	#c8c2c	;1353 LACY
	data.a	#c902c	;1354 LADY
	data.a	#2242c	;1355 LAID
	data.a	#7242c	;1356 LAIN
	data.a	#9242c	;1357 LAIR
	data.a	#2ac2c	;1358 LAKE
	data.a	#1342c	;1359 LAMB
	data.a	#2b42c	;1360 LAME
	data.a	#2382c	;1361 LAND
	data.a	#2b82c	;1362 LANE
	data.a	#3b82c	;1363 LANG
	data.a	#2482c	;1364 LARD
	data.a	#5c82c	;1365 LARK
	data.a	#9cc2c	;1366 LASS
	data.a	#a4c2c	;1367 LAST
	data.a	#2d02c	;1368 LATE
	data.a	#2542c	;1369 LAUD
	data.a	#d82c 	;1370 LAVA
	data.a	#75c2c	;1371 LAWN
	data.a	#9dc2c	;1372 LAWS
	data.a	#9e42c	;1373 LAYS
	data.a	#204ac	;1374 LEAD
	data.a	#304ac	;1375 LEAF
	data.a	#584ac	;1376 LEAK
	data.a	#704ac	;1377 LEAN
	data.a	#904ac	;1378 LEAR
	data.a	#594ac	;1379 LEEK
	data.a	#914ac	;1380 LEER
	data.a	#a18ac	;1381 LEFT
	data.a	#238ac	;1382 LEND
	data.a	#9b8ac	;1383 LENS
	data.a	#a38ac	;1384 LENT
	data.a	#73cac	;1385 LEON
	data.a	#5ccac	;1386 LESK
	data.a	#9ccac	;1387 LESS
	data.a	#a4cac	;1388 LEST
	data.a	#9d0ac	;1389 LETS
	data.a	#9052c	;1390 LIAR
	data.a	#28d2c	;1391 LICE
	data.a	#58d2c	;1392 LICK
	data.a	#2152c	;1393 LIED
	data.a	#7152c	;1394 LIEN
	data.a	#9952c	;1395 LIES
	data.a	#a952c	;1396 LIEU
	data.a	#2992c	;1397 LIFE
	data.a	#a192c	;1398 LIFT
	data.a	#2ad2c	;1399 LIKE
	data.a	#b12c 	;1400 LILA
	data.a	#a312c	;1401 LILT
	data.a	#cb12c	;1402 LILY
	data.a	#b52c 	;1403 LIMA
	data.a	#1352c	;1404 LIMB
	data.a	#2b52c	;1405 LIME
	data.a	#2392c	;1406 LIND
	data.a	#2b92c	;1407 LINE
	data.a	#5b92c	;1408 LINK
	data.a	#a392c	;1409 LINT
	data.a	#73d2c	;1410 LION
	data.a	#cd2c 	;1411 LISA
	data.a	#a4d2c	;1412 LIST
	data.a	#2d92c	;1413 LIVE
	data.a	#205ec	;1414 LOAD
	data.a	#305ec	;1415 LOAF
	data.a	#685ec	;1416 LOAM
	data.a	#705ec	;1417 LOAN
	data.a	#58dec	;1418 LOCK
	data.a	#a19ec	;1419 LOFT
	data.a	#29dec	;1420 LOGE
	data.a	#9a5ec	;1421 LOIS
	data.a	#b1ec 	;1422 LOLA
	data.a	#2b9ec	;1423 LONE
	data.a	#3b9ec	;1424 LONG
	data.a	#5bdec	;1425 LOOK
	data.a	#73dec	;1426 LOON
	data.a	#a3dec	;1427 LOOT
	data.a	#249ec	;1428 LORD
	data.a	#2c9ec	;1429 LORE
	data.a	#2cdec	;1430 LOSE
	data.a	#9cdec	;1431 LOSS
	data.a	#a4dec	;1432 LOST
	data.a	#255ec	;1433 LOUD
	data.a	#2d9ec	;1434 LOVE
	data.a	#2ddec	;1435 LOWE
	data.a	#58eac	;1436 LUCK
	data.a	#c8eac	;1437 LUCY
	data.a	#29eac	;1438 LUGE
	data.a	#2aeac	;1439 LUKE
	data.a	#ab2ac	;1440 LULU
	data.a	#23aac	;1441 LUND
	data.a	#3baac	;1442 LUNG
	data.a	#caac 	;1443 LURA
	data.a	#2caac	;1444 LURE
	data.a	#5caac	;1445 LURK
	data.a	#44eac	;1446 LUSH
	data.a	#a4eac	;1447 LUST
	data.a	#2b32c	;1448 LYLE
	data.a	#73b2c	;1449 LYNN
	data.a	#73f2c	;1450 LYON
	data.a	#cb2c 	;1451 LYRA
	data.a	#28c2d	;1452 MACE
	data.a	#2902d	;1453 MADE
	data.a	#49c2d	;1454 MAGI
	data.a	#2242d	;1455 MAID
	data.a	#6242d	;1456 MAIL
	data.a	#7242d	;1457 MAIN
	data.a	#2ac2d	;1458 MAKE
	data.a	#2b02d	;1459 MALE
	data.a	#4b02d	;1460 MALI
	data.a	#6302d	;1461 MALL
	data.a	#a302d	;1462 MALT
	data.a	#b82d 	;1463 MANA
	data.a	#7382d	;1464 MANN
	data.a	#cb82d	;1465 MANY
	data.a	#1c82d	;1466 MARC
	data.a	#2c82d	;1467 MARE
	data.a	#5c82d	;1468 MARK
	data.a	#9c82d	;1469 MARS
	data.a	#a482d	;1470 MART
	data.a	#cc82d	;1471 MARY
	data.a	#44c2d	;1472 MASH
	data.a	#5cc2d	;1473 MASK
	data.a	#9cc2d	;1474 MASS
	data.a	#a4c2d	;1475 MAST
	data.a	#2d02d	;1476 MATE
	data.a	#4502d	;1477 MATH
	data.a	#6542d	;1478 MAUL
	data.a	#7e42d	;1479 MAYO
	data.a	#204ad	;1480 MEAD
	data.a	#604ad	;1481 MEAL
	data.a	#704ad	;1482 MEAN
	data.a	#a04ad	;1483 MEAT
	data.a	#594ad	;1484 MEEK
	data.a	#a14ad	;1485 MEET
	data.a	#230ad	;1486 MELD
	data.a	#a30ad	;1487 MELT
	data.a	#7b4ad	;1488 MEMO
	data.a	#238ad	;1489 MEND
	data.a	#ab8ad	;1490 MENU
	data.a	#a48ad	;1491 MERT
	data.a	#44cad	;1492 MESH
	data.a	#9ccad	;1493 MESS
	data.a	#28d2d	;1494 MICE
	data.a	#2ad2d	;1495 MIKE
	data.a	#2312d	;1496 MILD
	data.a	#2b12d	;1497 MILE
	data.a	#5b12d	;1498 MILK
	data.a	#6312d	;1499 MILL
	data.a	#a312d	;1500 MILT
	data.a	#4b52d	;1501 MIMI
	data.a	#2392d	;1502 MIND
	data.a	#2b92d	;1503 MINE
	data.a	#4b92d	;1504 MINI
	data.a	#5b92d	;1505 MINK
	data.a	#a392d	;1506 MINT
	data.a	#2c92d	;1507 MIRE
	data.a	#9cd2d	;1508 MISS
	data.a	#a4d2d	;1509 MIST
	data.a	#2d12d	;1510 MITE
	data.a	#a512d	;1511 MITT
	data.a	#705ed	;1512 MOAN
	data.a	#a05ed	;1513 MOAT
	data.a	#58ded	;1514 MOCK
	data.a	#291ed	;1515 MODE
	data.a	#231ed	;1516 MOLD
	data.a	#2b1ed	;1517 MOLE
	data.a	#631ed	;1518 MOLL
	data.a	#a31ed	;1519 MOLT
	data.a	#b9ed 	;1520 MONA
	data.a	#5b9ed	;1521 MONK
	data.a	#a39ed	;1522 MONT
	data.a	#23ded	;1523 MOOD
	data.a	#73ded	;1524 MOON
	data.a	#93ded	;1525 MOOR
	data.a	#a3ded	;1526 MOOT
	data.a	#2c9ed	;1527 MORE
	data.a	#749ed	;1528 MORN
	data.a	#a49ed	;1529 MORT
	data.a	#9cded	;1530 MOSS
	data.a	#a4ded	;1531 MOST
	data.a	#451ed	;1532 MOTH
	data.a	#2d9ed	;1533 MOVE
	data.a	#40ead	;1534 MUCH
	data.a	#58ead	;1535 MUCK
	data.a	#212ad	;1536 MUDD
	data.a	#31aad	;1537 MUFF
	data.a	#2b2ad	;1538 MULE
	data.a	#632ad	;1539 MULL
	data.a	#5caad	;1540 MURK
	data.a	#44ead	;1541 MUSH
	data.a	#a4ead	;1542 MUST
	data.a	#2d2ad	;1543 MUTE
	data.a	#a52ad	;1544 MUTT
	data.a	#cb2d 	;1545 MYRA
	data.a	#4532d	;1546 MYTH
	data.a	#c9c2e	;1547 NAGY
	data.a	#6242e	;1548 NAIL
	data.a	#9242e	;1549 NAIR
	data.a	#2b42e	;1550 NAME
	data.a	#cc82e	;1551 NARY
	data.a	#44c2e	;1552 NASH
	data.a	#2d82e	;1553 NAVE
	data.a	#cd82e	;1554 NAVY
	data.a	#604ae	;1555 NEAL
	data.a	#904ae	;1556 NEAR
	data.a	#a04ae	;1557 NEAT
	data.a	#58cae	;1558 NECK
	data.a	#214ae	;1559 NEED
	data.a	#624ae	;1560 NEIL
	data.a	#630ae	;1561 NELL
	data.a	#73cae	;1562 NEON
	data.a	#7c8ae	;1563 NERO
	data.a	#9ccae	;1564 NESS
	data.a	#a4cae	;1565 NEST
	data.a	#9dcae	;1566 NEWS
	data.a	#a5cae	;1567 NEWT
	data.a	#9892e	;1568 NIBS
	data.a	#28d2e	;1569 NICE
	data.a	#58d2e	;1570 NICK
	data.a	#2b12e	;1571 NILE
	data.a	#b92e 	;1572 NINA
	data.a	#2b92e	;1573 NINE
	data.a	#405ee	;1574 NOAH
	data.a	#291ee	;1575 NODE
	data.a	#615ee	;1576 NOEL
	data.a	#631ee	;1577 NOLL
	data.a	#2b9ee	;1578 NONE
	data.a	#5bdee	;1579 NOOK
	data.a	#73dee	;1580 NOON
	data.a	#6c9ee	;1581 NORM
	data.a	#2cdee	;1582 NOSE
	data.a	#2d1ee	;1583 NOTE
	data.a	#755ee	;1584 NOUN
	data.a	#d9ee 	;1585 NOVA
	data.a	#292ae	;1586 NUDE
	data.a	#632ae	;1587 NULL
	data.a	#136ae	;1588 NUMB
	data.a	#4502f	;1589 OATH
	data.a	#c944f	;1590 OBEY
	data.a	#2bc4f	;1591 OBOE
	data.a	#7248f	;1592 ODIN
	data.a	#7a50f	;1593 OHIO
	data.a	#cb12f	;1594 OILY
	data.a	#a392f	;1595 OINT
	data.a	#c856f	;1596 OKAY
	data.a	#3058f	;1597 OLAF
	data.a	#c918f	;1598 OLDY
	data.a	#9d8f 	;1599 OLGA
	data.a	#7258f	;1600 OLIN
	data.a	#705af	;1601 OMAN
	data.a	#715af	;1602 OMEN
	data.a	#a25af	;1603 OMIT
	data.a	#28dcf	;1604 ONCE
	data.a	#995cf	;1605 ONES
	data.a	#cb1cf	;1606 ONLY
	data.a	#7d1cf	;1607 ONTO
	data.a	#9d5cf	;1608 ONUS
	data.a	#6064f	;1609 ORAL
	data.a	#c9e4f	;1610 ORGY
	data.a	#7b26f	;1611 OSLO
	data.a	#9a68f	;1612 OTIS
	data.a	#7d28f	;1613 OTTO
	data.a	#40eaf	;1614 OUCH
	data.a	#a4eaf	;1615 OUST
	data.a	#9d2af	;1616 OUTS
	data.a	#606cf	;1617 OVAL
	data.a	#716cf	;1618 OVEN
	data.a	#916cf	;1619 OVER
	data.a	#cb2ef	;1620 OWLY
	data.a	#9baef	;1621 OWNS
	data.a	#206b1	;1622 QUAD
	data.a	#a26b1	;1623 QUIT
	data.a	#23eb1	;1624 QUOD
	data.a	#28c32	;1625 RACE
	data.a	#58c32	;1626 RACK
	data.a	#c8c32	;1627 RACY
	data.a	#a1832	;1628 RAFT
	data.a	#29c32	;1629 RAGE
	data.a	#22432	;1630 RAID
	data.a	#62432	;1631 RAIL
	data.a	#72432	;1632 RAIN
	data.a	#2ac32	;1633 RAKE
	data.a	#5b832	;1634 RANK
	data.a	#a3832	;1635 RANT
	data.a	#2c832	;1636 RARE
	data.a	#44c32	;1637 RASH
	data.a	#2d032	;1638 RATE
	data.a	#2d832	;1639 RAVE
	data.a	#9e432	;1640 RAYS
	data.a	#204b2	;1641 READ
	data.a	#604b2	;1642 REAL
	data.a	#684b2	;1643 REAM
	data.a	#904b2	;1644 REAR
	data.a	#58cb2	;1645 RECK
	data.a	#214b2	;1646 REED
	data.a	#314b2	;1647 REEF
	data.a	#594b2	;1648 REEK
	data.a	#614b2	;1649 REEL
	data.a	#224b2	;1650 REID
	data.a	#724b2	;1651 REIN
	data.a	#b8b2 	;1652 RENA
	data.a	#238b2	;1653 REND
	data.a	#a38b2	;1654 RENT
	data.a	#a4cb2	;1655 REST
	data.a	#28d32	;1656 RICE
	data.a	#40d32	;1657 RICH
	data.a	#58d32	;1658 RICK
	data.a	#29132	;1659 RIDE
	data.a	#a1932	;1660 RIFT
	data.a	#63132	;1661 RILL
	data.a	#2b532	;1662 RIME
	data.a	#3b932	;1663 RING
	data.a	#5b932	;1664 RINK
	data.a	#2cd32	;1665 RISE
	data.a	#5cd32	;1666 RISK
	data.a	#2d132	;1667 RITE
	data.a	#205f2	;1668 ROAD
	data.a	#685f2	;1669 ROAM
	data.a	#905f2	;1670 ROAR
	data.a	#289f2	;1671 ROBE
	data.a	#58df2	;1672 ROCK
	data.a	#291f2	;1673 RODE
	data.a	#625f2	;1674 ROIL
	data.a	#631f2	;1675 ROLL
	data.a	#2b5f2	;1676 ROME
	data.a	#23df2	;1677 ROOD
	data.a	#33df2	;1678 ROOF
	data.a	#5bdf2	;1679 ROOK
	data.a	#6bdf2	;1680 ROOM
	data.a	#a3df2	;1681 ROOT
	data.a	#cdf2 	;1682 ROSA
	data.a	#2cdf2	;1683 ROSE
	data.a	#9cdf2	;1684 ROSS
	data.a	#ccdf2	;1685 ROSY
	data.a	#451f2	;1686 ROTH
	data.a	#a55f2	;1687 ROUT
	data.a	#2d9f2	;1688 ROVE
	data.a	#2ddf2	;1689 ROWE
	data.a	#9ddf2	;1690 ROWS
	data.a	#28ab2	;1691 RUBE
	data.a	#c8ab2	;1692 RUBY
	data.a	#292b2	;1693 RUDE
	data.a	#c92b2	;1694 RUDY
	data.a	#726b2	;1695 RUIN
	data.a	#2b2b2	;1696 RULE
	data.a	#3bab2	;1697 RUNG
	data.a	#9bab2	;1698 RUNS
	data.a	#a3ab2	;1699 RUNT
	data.a	#2ceb2	;1700 RUSE
	data.a	#44eb2	;1701 RUSH
	data.a	#5ceb2	;1702 RUSK
	data.a	#9ceb2	;1703 RUSS
	data.a	#a4eb2	;1704 RUST
	data.a	#452b2	;1705 RUTH
	data.a	#58c33	;1706 SACK
	data.a	#29833	;1707 SAFE
	data.a	#29c33	;1708 SAGE
	data.a	#22433	;1709 SAID
	data.a	#62433	;1710 SAIL
	data.a	#2b033	;1711 SALE
	data.a	#5b033	;1712 SALK
	data.a	#a3033	;1713 SALT
	data.a	#2b433	;1714 SAME
	data.a	#23833	;1715 SAND
	data.a	#2b833	;1716 SANE
	data.a	#3b833	;1717 SANG
	data.a	#5b833	;1718 SANK
	data.a	#c833 	;1719 SARA
	data.a	#65433	;1720 SAUL
	data.a	#2d833	;1721 SAVE
	data.a	#9e433	;1722 SAYS
	data.a	#70473	;1723 SCAN
	data.a	#90473	;1724 SCAR
	data.a	#a0473	;1725 SCAT
	data.a	#a3c73	;1726 SCOT
	data.a	#604b3	;1727 SEAL
	data.a	#684b3	;1728 SEAM
	data.a	#904b3	;1729 SEAR
	data.a	#a04b3	;1730 SEAT
	data.a	#214b3	;1731 SEED
	data.a	#594b3	;1732 SEEK
	data.a	#694b3	;1733 SEEM
	data.a	#714b3	;1734 SEEN
	data.a	#994b3	;1735 SEES
	data.a	#330b3	;1736 SELF
	data.a	#630b3	;1737 SELL
	data.a	#238b3	;1738 SEND
	data.a	#a38b3	;1739 SENT
	data.a	#9d0b3	;1740 SETS
	data.a	#75cb3	;1741 SEWN
	data.a	#38513	;1742 SHAG
	data.a	#68513	;1743 SHAM
	data.a	#b8513	;1744 SHAW
	data.a	#c8513	;1745 SHAY
	data.a	#21513	;1746 SHED
	data.a	#6a513	;1747 SHIM
	data.a	#72513	;1748 SHIN
	data.a	#23d13	;1749 SHOD
	data.a	#2bd13	;1750 SHOE
	data.a	#a3d13	;1751 SHOT
	data.a	#bbd13	;1752 SHOW
	data.a	#75513	;1753 SHUN
	data.a	#a5513	;1754 SHUT
	data.a	#58d33	;1755 SICK
	data.a	#29133	;1756 SIDE
	data.a	#a1933	;1757 SIFT
	data.a	#41d33	;1758 SIGH
	data.a	#71d33	;1759 SIGN
	data.a	#5b133	;1760 SILK
	data.a	#63133	;1761 SILL
	data.a	#7b133	;1762 SILO
	data.a	#a3133	;1763 SILT
	data.a	#2b933	;1764 SINE
	data.a	#3b933	;1765 SING
	data.a	#5b933	;1766 SINK
	data.a	#2c933	;1767 SIRE
	data.a	#2d133	;1768 SITE
	data.a	#9d133	;1769 SITS
	data.a	#ad133	;1770 SITU
	data.a	#a0573	;1771 SKAT
	data.a	#b9573	;1772 SKEW
	data.a	#22573	;1773 SKID
	data.a	#6a573	;1774 SKIM
	data.a	#72573	;1775 SKIN
	data.a	#a2573	;1776 SKIT
	data.a	#10593	;1777 SLAB
	data.a	#68593	;1778 SLAM
	data.a	#a0593	;1779 SLAT
	data.a	#c8593	;1780 SLAY
	data.a	#21593	;1781 SLED
	data.a	#b9593	;1782 SLEW
	data.a	#22593	;1783 SLID
	data.a	#6a593	;1784 SLIM
	data.a	#a2593	;1785 SLIT
	data.a	#13d93	;1786 SLOB
	data.a	#3bd93	;1787 SLOG
	data.a	#a3d93	;1788 SLOT
	data.a	#bbd93	;1789 SLOW
	data.a	#3d593	;1790 SLUG
	data.a	#6d593	;1791 SLUM
	data.a	#95593	;1792 SLUR
	data.a	#3bdb3	;1793 SMOG
	data.a	#3d5b3	;1794 SMUG
	data.a	#385d3	;1795 SNAG
	data.a	#13dd3	;1796 SNOB
	data.a	#bbdd3	;1797 SNOW
	data.a	#155d3	;1798 SNUB
	data.a	#3d5d3	;1799 SNUG
	data.a	#585f3	;1800 SOAK
	data.a	#905f3	;1801 SOAR
	data.a	#58df3	;1802 SOCK
	data.a	#91f3 	;1803 SODA
	data.a	#99f3 	;1804 SOFA
	data.a	#a19f3	;1805 SOFT
	data.a	#625f3	;1806 SOIL
	data.a	#231f3	;1807 SOLD
	data.a	#2b5f3	;1808 SOME
	data.a	#3b9f3	;1809 SONG
	data.a	#73df3	;1810 SOON
	data.a	#a3df3	;1811 SOOT
	data.a	#2c9f3	;1812 SORE
	data.a	#a49f3	;1813 SORT
	data.a	#655f3	;1814 SOUL
	data.a	#955f3	;1815 SOUR
	data.a	#75df3	;1816 SOWN
	data.a	#10693	;1817 STAB
	data.a	#38693	;1818 STAG
	data.a	#70693	;1819 STAN
	data.a	#90693	;1820 STAR
	data.a	#c8693	;1821 STAY
	data.a	#69693	;1822 STEM
	data.a	#b9693	;1823 STEW
	data.a	#92693	;1824 STIR
	data.a	#bbe93	;1825 STOW
	data.a	#15693	;1826 STUB
	data.a	#75693	;1827 STUN
	data.a	#40eb3	;1828 SUCH
	data.a	#992b3	;1829 SUDS
	data.a	#a26b3	;1830 SUIT
	data.a	#5b2b3	;1831 SULK
	data.a	#9b6b3	;1832 SUMS
	data.a	#3bab3	;1833 SUNG
	data.a	#5bab3	;1834 SUNK
	data.a	#2cab3	;1835 SURE
	data.a	#34ab3	;1836 SURF
	data.a	#106f3	;1837 SWAB
	data.a	#386f3	;1838 SWAG
	data.a	#686f3	;1839 SWAM
	data.a	#706f3	;1840 SWAN
	data.a	#a06f3	;1841 SWAT
	data.a	#c86f3	;1842 SWAY
	data.a	#6a6f3	;1843 SWIM
	data.a	#6d6f3	;1844 SWUM
	data.a	#58c34	;1845 TACK
	data.a	#a0c34	;1846 TACT
	data.a	#62434	;1847 TAIL
	data.a	#2ac34	;1848 TAKE
	data.a	#2b034	;1849 TALE
	data.a	#5b034	;1850 TALK
	data.a	#63034	;1851 TALL
	data.a	#5b834	;1852 TANK
	data.a	#5cc34	;1853 TASK
	data.a	#2d034	;1854 TATE
	data.a	#a5434	;1855 TAUT
	data.a	#604b4	;1856 TEAL
	data.a	#684b4	;1857 TEAM
	data.a	#904b4	;1858 TEAR
	data.a	#40cb4	;1859 TECH
	data.a	#694b4	;1860 TEEM
	data.a	#714b4	;1861 TEEN
	data.a	#a14b4	;1862 TEET
	data.a	#630b4	;1863 TELL
	data.a	#238b4	;1864 TEND
	data.a	#a38b4	;1865 TENT
	data.a	#6c8b4	;1866 TERM
	data.a	#748b4	;1867 TERN
	data.a	#9ccb4	;1868 TESS
	data.a	#a4cb4	;1869 TEST
	data.a	#70514	;1870 THAN
	data.a	#a0514	;1871 THAT
	data.a	#29514	;1872 THEE
	data.a	#69514	;1873 THEM
	data.a	#71514	;1874 THEN
	data.a	#c9514	;1875 THEY
	data.a	#72514	;1876 THIN
	data.a	#9a514	;1877 THIS
	data.a	#25514	;1878 THUD
	data.a	#3d514	;1879 THUG
	data.a	#58d34	;1880 TICK
	data.a	#29134	;1881 TIDE
	data.a	#c9134	;1882 TIDY
	data.a	#21534	;1883 TIED
	data.a	#91534	;1884 TIER
	data.a	#2b134	;1885 TILE
	data.a	#63134	;1886 TILL
	data.a	#a3134	;1887 TILT
	data.a	#2b534	;1888 TIME
	data.a	#b934 	;1889 TINA
	data.a	#2b934	;1890 TINE
	data.a	#a3934	;1891 TINT
	data.a	#cb934	;1892 TINY
	data.a	#2c934	;1893 TIRE
	data.a	#205f4	;1894 TOAD
	data.a	#79df4	;1895 TOGO
	data.a	#625f4	;1896 TOIL
	data.a	#231f4	;1897 TOLD
	data.a	#631f4	;1898 TOLL
	data.a	#2b9f4	;1899 TONE
	data.a	#3b9f4	;1900 TONG
	data.a	#cb9f4	;1901 TONY
	data.a	#5bdf4	;1902 TOOK
	data.a	#63df4	;1903 TOOL
	data.a	#a3df4	;1904 TOOT
	data.a	#2c9f4	;1905 TORE
	data.a	#749f4	;1906 TORN
	data.a	#2d1f4	;1907 TOTE
	data.a	#955f4	;1908 TOUR
	data.a	#a55f4	;1909 TOUT
	data.a	#75df4	;1910 TOWN
	data.a	#38654	;1911 TRAG
	data.a	#68654	;1912 TRAM
	data.a	#c8654	;1913 TRAY
	data.a	#29654	;1914 TREE
	data.a	#59654	;1915 TREK
	data.a	#3a654	;1916 TRIG
	data.a	#6a654	;1917 TRIM
	data.a	#7a654	;1918 TRIO
	data.a	#23e54	;1919 TROD
	data.a	#a3e54	;1920 TROT
	data.a	#cbe54	;1921 TROY
	data.a	#2d654	;1922 TRUE
	data.a	#8ab4 	;1923 TUBA
	data.a	#28ab4	;1924 TUBE
	data.a	#58eb4	;1925 TUCK
	data.a	#a1ab4	;1926 TUFT
	data.a	#bab4 	;1927 TUNA
	data.a	#2bab4	;1928 TUNE
	data.a	#3bab4	;1929 TUNG
	data.a	#34ab4	;1930 TURF
	data.a	#74ab4	;1931 TURN
	data.a	#5ceb4	;1932 TUSK
	data.a	#3a6f4	;1933 TWIG
	data.a	#726f4	;1934 TWIN
	data.a	#a26f4	;1935 TWIT
	data.a	#70595	;1936 ULAN
	data.a	#a25d5	;1937 UNIT
	data.a	#29e55	;1938 URGE
	data.a	#21675	;1939 USED
	data.a	#91675	;1940 USER
	data.a	#99675	;1941 USES
	data.a	#40695	;1942 UTAH
	data.a	#62436	;1943 VAIL
	data.a	#72436	;1944 VAIN
	data.a	#2b036	;1945 VALE
	data.a	#cc836	;1946 VARY
	data.a	#2cc36	;1947 VASE
	data.a	#a4c36	;1948 VAST
	data.a	#604b6	;1949 VEAL
	data.a	#90b6 	;1950 VEDA
	data.a	#624b6	;1951 VEIL
	data.a	#724b6	;1952 VEIN
	data.a	#238b6	;1953 VEND
	data.a	#a38b6	;1954 VENT
	data.a	#148b6	;1955 VERB
	data.a	#cc8b6	;1956 VERY
	data.a	#7d0b6	;1957 VETO
	data.a	#28d36	;1958 VICE
	data.a	#b9536	;1959 VIEW
	data.a	#2b936	;1960 VINE
	data.a	#2cd36	;1961 VISE
	data.a	#225f6	;1962 VOID
	data.a	#a31f6	;1963 VOLT
	data.a	#2d1f6	;1964 VOTE
	data.a	#58c37	;1965 WACK
	data.a	#29037	;1966 WADE
	data.a	#29c37	;1967 WAGE
	data.a	#62437	;1968 WAIL
	data.a	#a2437	;1969 WAIT
	data.a	#2ac37	;1970 WAKE
	data.a	#2b037	;1971 WALE
	data.a	#5b037	;1972 WALK
	data.a	#63037	;1973 WALL
	data.a	#a3037	;1974 WALT
	data.a	#23837	;1975 WAND
	data.a	#2b837	;1976 WANE
	data.a	#3b837	;1977 WANG
	data.a	#a3837	;1978 WANT
	data.a	#24837	;1979 WARD
	data.a	#6c837	;1980 WARM
	data.a	#74837	;1981 WARN
	data.a	#a4837	;1982 WART
	data.a	#44c37	;1983 WASH
	data.a	#a4c37	;1984 WAST
	data.a	#9d037	;1985 WATS
	data.a	#a5037	;1986 WATT
	data.a	#2d837	;1987 WAVE
	data.a	#cd837	;1988 WAVY
	data.a	#9e437	;1989 WAYS
	data.a	#584b7	;1990 WEAK
	data.a	#604b7	;1991 WEAL
	data.a	#704b7	;1992 WEAN
	data.a	#904b7	;1993 WEAR
	data.a	#214b7	;1994 WEED
	data.a	#594b7	;1995 WEEK
	data.a	#924b7	;1996 WEIR
	data.a	#230b7	;1997 WELD
	data.a	#630b7	;1998 WELL
	data.a	#a30b7	;1999 WELT
	data.a	#a38b7	;2000 WENT
	data.a	#2c8b7	;2001 WERE
	data.a	#a48b7	;2002 WERT
	data.a	#a4cb7	;2003 WEST
	data.a	#68517	;2004 WHAM
	data.a	#a0517	;2005 WHAT
	data.a	#29517	;2006 WHEE
	data.a	#71517	;2007 WHEN
	data.a	#a1517	;2008 WHET
	data.a	#bd17 	;2009 WHOA
	data.a	#6bd17	;2010 WHOM
	data.a	#58d37	;2011 WICK
	data.a	#29937	;2012 WIFE
	data.a	#23137	;2013 WILD
	data.a	#63137	;2014 WILL
	data.a	#23937	;2015 WIND
	data.a	#2b937	;2016 WINE
	data.a	#3b937	;2017 WING
	data.a	#5b937	;2018 WINK
	data.a	#7b937	;2019 WINO
	data.a	#2c937	;2020 WIRE
	data.a	#2cd37	;2021 WISE
	data.a	#44d37	;2022 WISH
	data.a	#45137	;2023 WITH
	data.a	#331f7	;2024 WOLF
	data.a	#a39f7	;2025 WONT
	data.a	#23df7	;2026 WOOD
	data.a	#63df7	;2027 WOOL
	data.a	#249f7	;2028 WORD
	data.a	#2c9f7	;2029 WORE
	data.a	#5c9f7	;2030 WORK
	data.a	#6c9f7	;2031 WORM
	data.a	#749f7	;2032 WORN
	data.a	#2d9f7	;2033 WOVE
	data.a	#a2657	;2034 WRIT
	data.a	#73b37	;2035 WYNN
	data.a	#2b039	;2036 YALE
	data.a	#3b839	;2037 YANG
	data.a	#5b839	;2038 YANK
	data.a	#24839	;2039 YARD
	data.a	#74839	;2040 YARN
	data.a	#65c39	;2041 YAWL
	data.a	#75c39	;2042 YAWN
	data.a	#404b9	;2043 YEAH
	data.a	#904b9	;2044 YEAR
	data.a	#630b9	;2045 YELL
	data.a	#9df9 	;2046 YOGA
	data.a	#2adf9	;2047 YOKE
bend:

	end
