/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_keymgrsubr.C	1.24 96/01/31"

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <ctype.h>
#include <memory.h>
#include "Time.h"
#include "Bigint.h"
#include "Bstream.h"
#include "ObjId.h"
#include "Name.h"
#include "X509Cert.h"
#include "SkipCert.h"
#include "X509skip.h"
#include "HashCert.h"
#include "malloc.h"
#include "utils.h"
#include "Sig.h"
#include "skip_log.h"
#include <skip_crypt.h>

#include "my_types.h"
#include "skip_conf.h"
#include "skip_keymgr.h"
#include "skip_cache.h"
#include "skip_enc_alg.h"
#include "skip_certbase.h"

Bstream skip_generate_A_kp(Bstream, int);
Bstream skip_generate_E_kp(Bstream, int);
Bstream kijtokijn(Bstream, u_long);

extern void *dh_params;
extern Bstream mydhsecret;
extern Bstream dhparams;
extern Bstream CA_X509_Cert;
extern Bigint master_mod, master_base;
extern skip_fetch_cert;
extern int skip_fetch_cert; 
extern secret_expiration;
extern int verbose;

secret_cache kij_cache;

// Routine which generates a random kp, a random iv, sets the n-counter 
//and encrypts the kp with the shared secret

skip_generate_kp_iv(const int ver, const Bstream keyid, u_char s_nsid,
		    ENC_ALG_TYPE kp_alg, 
		    ENC_ALG_TYPE kij_alg, ENC_ALG_TYPE auth_alg,
		    Bstream& kp, Bstream& e_kp, Bstream& a_kp,
		    Bstream& iv, Bstream& encrypted_kp, u_long ncounter)
{
	unsigned char zero[8];
	Bstream kij;
	String temp;

	int keylen;
	bzero(zero, sizeof(zero));
	int status;

	status =  skip_get_pair_key(ver, keyid, s_nsid, kij_alg, ncounter, 
					1, kij);
	if (status != KEYMGR_OK)
		return status;
#ifdef DEBUG
	temp=keyid.gethexstr();
	fprintf(stdout, "keyid = %x",(const char *)temp);
	fprintf(stdout, "kij = "); kij.print(); fflush(stdout);
#endif DEBUG
	keylen=cryptor_get_keylen(ver, KPALG, kp_alg);
	if (keylen == 0) {
		skip_log(SKIP_ERROR,"Unsupported Traffic encryption Algorithm %d",kp_alg);
		return KEYMGR_BADALG;
	}
	kp = get_random_bytes(keylen);
#ifdef DEBUG
	fprintf(stdout,"kp=");kp.print();fflush(stdout);
#endif
	if (cryptor_get_flags(ver, KPALG, kp_alg) & SKIP_STREAM_CIPHER) {
		iv = Bstream(8, zero);
	} else {
		iv = get_random_bytes(cryptor_get_ivlen(ver, KPALG, kp_alg));
	}
	encrypted_kp = skip_encrypt(ver, KIJALG, kij_alg, kij, kp);

// Truncated the key to support to it's correct length.
	int kplen=cryptor_get_keylen(ver, KPALG, kp_alg);
	kp = Bstream(kplen, kp.getdatap()+(kp.getlength()-kplen));

	e_kp=skip_generate_E_kp(kp, keylen);
	a_kp=skip_generate_A_kp(kp, keylen);
#ifdef DEBUG
	fprintf(stdout,"encrypted kp=");encrypted_kp.print();fflush(stdout);
#endif
	return KEYMGR_OK;
}

int
skip_decrypt_kp(const int ver, const Bstream keyid, u_char s_nsid,
		const ENC_ALG_TYPE kij_alg, 
	        const ENC_ALG_TYPE kp_alg, const ENC_ALG_TYPE auth_alg,
		const Bstream& encrypted_kp, Bstream &kp, 
		Bstream& e_kp, Bstream &a_kp, u_long ncounter)
{
	int keylen;	
	int offset;
	int update=0;
	Bstream kij;


	keylen=cryptor_get_Ekeylen(ver, KPALG, kp_alg);

	if (ver > 1) {
		offset = ncounter - CURRENT_NCOUNTER;
		if (offset == 0 )
			update = 1;
		else if (abs(offset) >1 )	 // n counter out of range
			return KEYMGR_BAD_N_OFFSET;
		else
			update = 0;
	}
	int status;
	status = skip_get_pair_key(ver, keyid, s_nsid, kij_alg, ncounter, 
				 update, kij);
	if  (status != 0)
		return status;
#ifdef DEBUG
	fprintf(stdout, "skip_decrypt_kp: kij = "); kij.print(); fflush(stdout);
#endif DEBUG
	kp = skip_decrypt(ver, KIJALG, kij_alg, kij, encrypted_kp);

// Truncated the key to support to it's correct length.
	int kplen=cryptor_get_keylen(ver, KPALG, kp_alg);
	kp = Bstream(kplen, kp.getdatap()+(kp.getlength()-kplen));

	e_kp = skip_generate_E_kp(kp, keylen);
	a_kp = skip_generate_A_kp(kp, keylen);
	
#ifdef DEBUG
	fprintf(stdout,"encrypted kp=");encrypted_kp.print();fflush(stdout);
#endif
#ifdef DEBUG
	fprintf(stdout,"kp=");kp.print();fflush(stdout);
#endif
	return KEYMGR_OK;
}

int 
skip_get_pair_key(int ver, const Bstream keyid, u_char nsid, ENC_ALG_TYPE alg, 
		  u_long ncounter, int update, Bstream &kij)
{
	Bstream nullstr;
	u_long exp;
	struct secret_cache_elem *elem;
	int keylen;
	int offset;
	int len;
	int status;
	String temp;
	status = 0;
	if (!nsid)
		nsid=1;
	keylen = cryptor_get_Ekeylen(ver, KIJALG,  alg);
	elem=kij_cache.get_entry(nsid, keyid);
// should we exit?
	if (secret_expiration < time(0) && mydhsecret.getlength() != 0 &&
			elem->keytype == KEY_DH) {
		skip_log(SKIP_ERROR,"Local DH Secret has expired! DH calculations disabled");
		Bstream zero;
		mydhsecret=zero;
		return KEYMGR_LOCAL_EXPIRED;
	}
	if (elem == NULL) {
		Bstream secret;
		if (mydhsecret.getlength() == 0) {
			return KEYMGR_NO_MANUAL_KEY;
		}

		elem = new secret_cache_elem;
		temp=keyid.gethexstr();
		skip_log(SKIP_NOTICE,"Calculating secret for 0x%s...", 
			(const char*)temp);
		secret = skip_dh_key_agree(keyid, nsid,  exp);
		if (secret.getlength() == 0) {
			return KEYMGR_NOCERT;
		}
		skip_log(SKIP_NOTICE,"...Done Calculating");
		elem->keyid = keyid;
		elem->nsid  = nsid;
		elem->ncounter = CURRENT_NCOUNTER;

		// Truncate the secret to the maximum kp size needed
		len=secret.getlength();
		elem->kij = secret;

#ifdef notyet
		elem->kij = Bstream(MIN_KIJ_SIZE, 
				    secret.getdatap()+len-MIN_KIJ_SIZE);
#endif
#ifdef DEBUG
		printf("max kij_size = %d, kij=%d\n", MIN_KIJ_SIZE,  
					  elem->kij.getlength());
#endif
		elem->expires = exp;
		elem->keytype = KEY_DH;
		kij_cache.insert(elem);
#ifdef DEBUG
		printf("secret_ij = "); secret.print();  fflush(stdout);
#endif DEBUG
	}

	if (ver > 1) {
		if (update )  {	// Make cache current if we're updating
			elem->set_ncounter(ncounter);
			kij_cache.insert(elem);
		}
		offset = elem->ncounter-ncounter;

		if ( abs(offset) > 1) {
			skip_log(SKIP_ERROR,"Error: wacky offset %d\n", offset);
			return KEYMGR_BAD_N_OFFSET;
		}
		kij=elem->kij;
		len = kij.getlength()-keylen;
		kij = Bstream(keylen, kij.getdatap()+len);
		kij = kijtokijn(kij, ncounter);
	} else {
		kij=elem->kij;
	}

	len = kij.getlength()-keylen;
	kij = Bstream(keylen, kij.getdatap()+len);
	return KEYMGR_OK;
}

Bstream
skip_dh_key_agree(const Bstream keyid, u_char nsid, u_long &exp)
{
	Bstream nullstr;
	int n;
	if (nsid == 0)
		nsid = 1;
	Bstream other_public_value = skip_get_dh_public_value(keyid, nsid, exp);
	if (other_public_value.getlength() == 0) {
		return nullstr;
	}
	return compute_dh_secret(dh_params, mydhsecret, other_public_value);
}


Bstream
skip_get_dh_public_value(const Bstream keyid, u_char nsid, u_long &expires)
{
	Bstream nullstr;
	Bstream dh_certstr;
	Bstream certstr;
	Name junk;
	String temp;
	SkipCert *dh_cert;

	int ret = skip_get_dh_cert(keyid,  nsid , SKIP_CERT_X509, dh_certstr);
	if (ret) {
		return nullstr;
	}
	
	if (nsid == 8){ 			// Should be certtype not NSID
		dh_cert = new HashCert;
	}
	else {
		dh_cert = new X509SkipCert;
	}
	
	if (dh_cert->decode(dh_certstr)) {
		temp=keyid.gethexstr();
		skip_log(SKIP_ERROR, "Unable to decode certificate for %s",(const char*)temp);
		return nullstr;
	}
	if (nsid == 8)
		certstr=dh_cert->skip_name();
	else
		certstr= CA_X509_Cert;

	if (!dh_cert->isValid(certstr)) {
		temp=keyid.gethexstr();
		skip_log(SKIP_ERROR, "Invalid certificate for %s",(const char*)temp);
		return nullstr;
	}

	Bigint Mod, Base, pubval;

	if (dh_cert->skip_params(Base, Mod)) {
		skip_log(SKIP_ERROR,"Certificate g+p do not decode");
		return nullstr;
	}	

	if ( Mod != master_mod || Base != master_base){
		skip_log(SKIP_ERROR,"Certificate g+p do not match dh_params");
		temp = Mod.getnumstr();
		
		printf("Mod: %s != ",(const char *)temp);
		temp = master_mod.getnumstr();
		printf("%s\n",(const char *)temp);

		temp=Base.getnumstr();
		printf("Base: %s != ",(const char *)temp);
		temp=master_base.getnumstr();
		printf("%s\n",(const char *)temp);
		return nullstr;
	}
	expires=dh_cert->skip_notvalidafter();
	Bstream retval=Bigint_to_Bstr(dh_cert->skip_pubkey());
	delete dh_cert;
	return retval;
}

Bstream bn_exponentiate(Bstream, Bstream, Bstream);

Bstream kijtokijn(Bstream kij, u_long ncounter)
{
	Bigint ncount=ncounter;
	Bstream result;
	u_long ncountnet;
	char zero, one;
	ncountnet=htonl(ncounter);
	zero=0, one=1;
	result = MD5(kij+ Bstream(4,(u_char *)&ncountnet)+
			  Bstream(1,(u_char *)&one))+
	         MD5(kij+ Bstream(4,(u_char *)&ncountnet) +
			  Bstream(1,(u_char *)&zero));
	return result;
}


Bstream
skip_generate_E_kp(Bstream kp, int size)
{
	unsigned char c;
	Bstream result;
	c=1;
	result=MD5(kp+Bstream(1,&c));
	c=0;
	result=result+MD5(kp+Bstream(1,&c));
	return Bstream(size, result.getdatap()+result.getlength()-size);
}

	
Bstream
skip_generate_A_kp(Bstream kp, int size) 
{
	unsigned char  c;
	Bstream result;

	c=3;
	result=MD5(kp+Bstream(1,&c));
	c=2;
	result=result+MD5(kp+Bstream(1,&c));
	return Bstream(size, result.getdatap()+result.getlength()-size);
}
