/*
This code is copyright (C) 1998 Robert O'Callahan.
This code is free for non-commercial use. Modification in all forms is permitted.
This license continues to apply to any modified versions. This license text must be
reproduced and distributed with any modified versions.
As a matter of courtesy I (Robert O'Callahan) would like to be informed of
any potentially useful modifications.
*/

#ifndef __TTSSH_H
#define __TTSSH_H

#include "teraterm.h"
#include "tttypes.h"
#include "ttplugin.h"
#include "util.h"
#include "pkt.h"
#include "ssh.h"
#include "auth.h"
#include "crypt.h"
#include "hosts.h"
#include "fwd.h"

HANDLE hInst; /* Instance handle of TTXSSH.DLL */

#define ID_ABOUTMENU 62501
#define ID_SSHAUTH   62502
#define ID_SSHSETUPMENU 62503
#define ID_SSHUNKNOWNHOST 62504
#define ID_SSHDIFFERENTHOST 62505
#define ID_SSHAUTHSETUPMENU 62506
#define ID_SSHASYNCMESSAGEBOX 62507

/*
These are the fields that WOULD go in Teraterm's 'ts' structure, if
we could put them there.
*/
typedef struct _TS_SSH {
  BOOL Enabled;
  int CompressionLevel; /* 0 = NONE, else 1-9 */
  char DefaultUserName[256];
  /* this next option is a string of digits. Each digit represents a
     cipher. The first digit is the most preferred cipher, and so on.
     The digit SSH_CIPHER_NONE signifies that any ciphers after it are
     disabled. */
  char CipherOrder[16];
  char KnownHostsFiles[2048];
  int DefaultAuthMethod;
  char DefaultRhostsLocalUserName[256];
  char DefaultRhostsHostPrivateKeyFile[1024];
  char DefaultRSAPrivateKeyFile[1024];
  char DefaultForwarding[2048];
} TS_SSH;

typedef struct _TInstVar {
  PTTSet ts;
  PComVar cv;
  TS_SSH FAR * ts_SSH;

  int fatal_error;
  int showing_err;
  char FAR * err_msg;

  Tconnect Pconnect;
  Trecv Precv;
  Tsend Psend;
  TWSAAsyncSelect PWSAAsyncSelect;
  TWSAGetLastError PWSAGetLastError;

  PReadIniFile ReadIniFile;
  PWriteIniFile WriteIniFile;
  PParseParam ParseParam;

  SOCKET socket;
  HWND NotificationWindow;
  unsigned int notification_msg;
  long notification_events;
  HICON OldSmallIcon;
  HICON OldLargeIcon;

  BOOL hostdlg_activated;
  BOOL hostdlg_Enabled;

  PKTState pkt_state;
  SSHState ssh_state;
  AUTHState auth_state;
  CRYPTState crypt_state;
  HOSTSState hosts_state;
  FWDState fwd_state;

  TS_SSH session_settings;
  TS_SSH settings;
} TInstVar;

void notify_established_secure_connection(struct _TInstVar FAR * pvar);
void notify_closed_connection(struct _TInstVar FAR * pvar);
void notify_nonfatal_error(struct _TInstVar FAR * pvar, char FAR * msg);
void notify_fatal_error(struct _TInstVar FAR * pvar, char FAR * msg);

void get_teraterm_dir_relative_name(char FAR * buf, int bufsize, char FAR * basename);
int copy_teraterm_dir_relative_path(char FAR * dest, int destsize, char FAR * basename);

#endif
