RCSID $Id: net.netlink.netlink_dev.c,v 1.3 1999/09/17 17:54:45 rgb Exp $
--- ./net/netlink/netlink_dev.c.preipsec	Wed Jun  2 14:29:28 1999
+++ ./net/netlink/netlink_dev.c	Sat Aug 28 02:25:00 1999
@@ -29,7 +29,7 @@
 #include <asm/system.h>
 #include <asm/uaccess.h>
 
-static unsigned open_map = 0;
+extern unsigned netlink_open_map;
 static struct socket *netlink_user[MAX_LINKS];
 
 /*
@@ -109,10 +109,10 @@
 	
 	if (minor>=MAX_LINKS)
 		return -ENODEV;
-	if (open_map&(1<<minor))
+	if (netlink_open_map&(1<<minor))
 		return -EBUSY;
 
-	open_map |= (1<<minor);
+	netlink_open_map |= (1<<minor);
 	MOD_INC_USE_COUNT;
 	
 	err = -EINVAL;
@@ -143,7 +143,7 @@
 	return 0;
 
 out:
-	open_map &= ~(1<<minor);
+	netlink_open_map &= ~(1<<minor);
 	MOD_DEC_USE_COUNT;
 	return err;
 }
@@ -154,7 +154,7 @@
 	struct socket *sock = netlink_user[minor];
 
 	netlink_user[minor] = NULL;
-	open_map &= ~(1<<minor);
+	netlink_open_map &= ~(1<<minor);
 	sock_release(sock);
 	MOD_DEC_USE_COUNT;
 	return 0;
