/* identity representation, as in IKE ID Payloads (RFC 2407 DOI 4.6.2.1)
 * Copyright (C) 1999  D. Hugh Redelmeier
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: id.h,v 1.4 1999/12/16 10:31:13 dhr Exp $
 */

struct id {
    int kind;	/* ID_* value */
    struct in_addr ipv4;	/* (network order) ID_IPV4_ADDR */
    chunk_t name;	/* ID_FQDN, ID_USER_FQDN (with @) */
    struct id *next;
};

extern const struct id empty_id;

extern const char *atoid(char *src, struct id *id);
extern int idtoa(struct id *id, char *dst, size_t dstlen);
struct end;	/* forward declaration of tag (defined in connections.h) */
extern struct id *clone_id(const struct id *src);
extern void clone_id_content(struct id *id);
extern void free_id(struct id *id);
extern void free_id_content(struct id *id);
extern bool id_same(const struct id *a, const struct id *b);

struct isakmp_ipsec_id;	/* forward declaration of tag (defined in packet.h) */
extern void
    build_id_payload(struct isakmp_ipsec_id *hd, chunk_t *tl, struct end *end);
