/*
 *
 *			   IPSEC for Linux
 *		         Preliminary Release
 * 
 *	    Copyright (C) 1996, John Ioannidis <ji@hol.gr>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

/*
 * $Id: addrt.c,v 0.3 1996/11/20 14:51:32 ji Rel $
 *
 * $Log: addrt.c,v $
 * Revision 0.3  1996/11/20 14:51:32  ji
 * Fixed problems with #include paths.
 * Changed (incorrect) references to ipsp into ipsec.
 *
 * Revision 0.2  1996/11/08 15:45:24  ji
 * First limited release.
 *
 *
 */

#include <sys/types.h>
#include <string.h>
#include <errno.h>

#include <sys/socket.h>
#include <linux/skbuff.h>
#include <netinet/in.h>
#include <arpa/inet.h>



#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_netlink.h"


#include <stdio.h>

main(argc, argv)
int argc;
char **argv;
{
	int fd;
	struct encap_msghdr emh;
	if (argc != 7)
	{
		fprintf(stderr, "usage: %s src srcmask dst dstmask edst spi\n", argv[0]);
		exit(1);
	}
	
  
	fd = open("/dev/ipsec", 2);
	if (fd < 0)
		perror("open"), exit(1);
	
	emh.em_msglen= sizeof emh;
	emh.em_version = PFENCAP_VERSION_1;
	emh.em_type = EMT_SETEROUTE;
	emh.em_eaddr.sen_len = emh.em_emask.sen_len = sizeof (struct sockaddr_encap);
	emh.em_eaddr.sen_family = emh.em_emask.sen_family = 26;
	emh.em_eaddr.sen_type = SENT_IP4;
	emh.em_emask.sen_type = 255;
	
	emh.em_eaddr.sen_ip_src.s_addr = inet_addr(argv[1]);
	emh.em_eaddr.sen_ip_dst.s_addr = inet_addr(argv[3]);
	emh.em_emask.sen_ip_src.s_addr = inet_addr(argv[2]);
	emh.em_emask.sen_ip_dst.s_addr = inet_addr(argv[4]);
	emh.em_erdst.s_addr = inet_addr(argv[5]);
	emh.em_erspi = htonl(strtol(argv[6], NULL, 16));

	if (write(fd, &emh, sizeof emh) != sizeof emh)
		perror("write");
}
