/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

/*
 * This file defines various constant values.
 */

#define DEFAULTGENERATOR "2"

#define GROUPDEFAULT "FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245 E485B576 625E7EC6 F44C42E9 A63A3620 FFFFFFFF FFFFFFFF"
#define LOCALSECRETSIZE (256 / 8)	/* 256 bits */

#define DEFAULTNONCESIZE (128 / 8)	/* 128 bits */

#define MINIMUM_PUBLIC_VALUE_SIZE 32    

#define COOKIE_SIZE 8

#ifndef PORT
#define PORT 500
#endif

#define DES_CBC_BLOCK_SIZE        8

/* Timer events */

#define EVENT_REINIT_SECRET                     0 /* Refresh cookie secret */
#define EVENT_RETRANSMIT                        1 /* Retransmit packet */
#define EVENT_CLEANUP				2 /* Cleanup responder state */
#define EVENT_SA_EXPIRE				3 /* SA expiration event */

#define EVENT_REINIT_SECRET_DELAY               3600 /* 1 hour */
#define EVENT_RETRANSMIT_DELAY                  30 /* Half a minute */
#define EVENT_CLEANUP_DELAY			120 /* 2 minutes */

#define DEFAULT_SA_EXPIRE                       3600

/* Misc. stuff */

#define SECRET_VALUE_LENGTH  20	/* This is also the size of and SHA-1 digest */

#define ISAKMP_RESPONDER     0
#define ISAKMP_INITIATOR     1

#define MAXIMUM_RETRANSMISSIONS              2

#define UDP_SIZE             65536

#define ZERO_FILE            "/dev/zero"
#define LINUX_RANDOM_FILE    "/dev/urandom"

/* Version numbers */

#define ISAKMP_MAJOR_VERSION   0x1
#define ISAKMP_MINOR_VERSION   0x0

#define ISAKMP_DOI_IPSEC           1
#define IPSEC_DOI_SITUATION_LENGTH 4
#define IPSEC_DOI_LDI_LENGTH       4
#define IPSEC_DOI_SPI_SIZE         8

/* State of exchange for Initiator */

#define OAKLEY_MAIN_I_1       0
#define OAKLEY_MAIN_I_2       1
#define OAKLEY_MAIN_I_3       2
#define OAKLEY_MAIN_I_4       6

/* State of exchange for Responder */

#define OAKLEY_MAIN_R_1       3
#define OAKLEY_MAIN_R_2       4
#define OAKLEY_MAIN_R_3       5

/* Payload types */

#define ISAKMP_NEXT_NONE       0	/* No other payload following */
#define ISAKMP_NEXT_SA         1	/* Security Association */
#define ISAKMP_NEXT_P          2	/* Proposal */
#define ISAKMP_NEXT_T          3	/* Transform */
#define ISAKMP_NEXT_KE         4	/* Key Exchange */
#define ISAKMP_NEXT_ID         5	/* Identification */
#define ISAKMP_NEXT_CERT       6	/* Certificate */
#define ISAKMP_NEXT_CR         7	/* Certificate Request */
#define ISAKMP_NEXT_HASH       8	/* Hash */
#define ISAKMP_NEXT_SIG        9	/* Signature */
#define ISAKMP_NEXT_NONCE      10	/* Nonce */
#define ISAKMP_NEXT_N          11	/* Notification */
#define ISAKMP_NEXT_D          12       /* Delete */

/* Exchange types */

#define ISAKMP_XCHG_NONE       0
#define ISAKMP_XCHG_BASE       1
#define ISAKMP_XCHG_IDPROT     2	/* ID Protection */
#define ISAKMP_XCHG_AO         3	/* Authentication Only */
#define ISAKMP_XCHG_AGGR       4	/* Aggressive */
#define ISAKMP_XCHG_INFO       5	/* Informational */

/* Extra exchange types, defined by Oakley */

#define ISAKMP_XCHG_QUICK      32	/* Oakley Quick Mode */
#define ISAKMP_XCHG_NGRP       33	/* Oakley New Group Mode */

/* Flag bits */

#define ISAKMP_FLAG_ENCRYPTION   0x1
#define ISAKMP_FLAG_COMMIT       0x2

/* Situation definition for IPsec DOI */

#define SIT_IDENTITY_ONLY        0x01
#define SIT_SECRECY              0x02
#define SIT_INTEGRITY            0x04

/* Protocol IDs */

#define PROTO_RESERVED           0
#define PROTO_ISAKMP             1
#define PROTO_IPSEC_AH           2
#define PROTO_IPSEC_ESP          3

/* IPsec ISAKMP transform values */

#define KEY_RESERVED             0
#define KEY_OAKLEY               1
#define KEY_MANUAL               2
#define KEY_KDC                  3

/* IPsec AH transform values */

#define AH_RESERVED              0
#define AH_MD5_KPDK              1
#define AH_MD5                   2
#define AH_SHA                   3

/* IPsec ESP transform values */

#define ESP_RESERVED             0
#define ESP_DES_CBC              1
#define ESP_DES                  2
#define ESP_3DES                 3
#define ESP_RC5                  4

/* SA attributes */

#define SA_AUTH_KEY_LIFE_TYPE       1	/* B */
#define SA_AUTH_KEY_LIFE_DURATION   2	/* B/V */
#define SA_ENC_KEY_LIFE_TYPE        3	/* B */
#define SA_ENC_KEY_LIFE_DURATION    4	/* B/V */
#define SA_LIFE_TYPE                5	/* B */
#define SA_LIFE_DURATION            6	/* B/V */
#define SA_REPLAY_PROTECTION        7	/* B */
#define SA_GROUP_DESCRIPTION        8	/* B */
#define SA_CA_DISTINGUISHED_NAME    9	/* B */
#define SA_ENCAPSULATION_MODE       10	/* B */
#define SA_HMAC_ALGORITHM           11	/* B */

/* Identification type values */

#define ID_RESERVED                 0
#define ID_IPV4_ADDR                1
#define ID_FQDN                     2
#define ID_USER_FQDN                3
#define ID_IPV4_ADDR_SUBNET         4
#define ID_IPV6_ADDR                5
#define ID_IPV6_ADDR_SUBNET         6
#define ID_IPV4_ADDR_RANGE          7
#define ID_IPV6_ADDR_RANGE          8

/* Goals for establishing an SA */

#define GOAL_ENCRYPT                0x1
#define GOAL_AUTHENTICATE           0x2
#define GOAL_TUNNEL                 0x4
#define GOAL_KEYMANAGEMENT          0x8

/* Oakley transform attributes */

#define OAKLEY_ENCRYPTION_ALGORITHM   1
#define OAKLEY_HASH_ALGORITHM         2
#define OAKLEY_AUTHENTICATION_METHOD  3
#define OAKLEY_GROUP_DESCRIPTION      4
#define OAKLEY_GROUP_TYPE             5
#define OAKLEY_GROUP_PRIME            6
#define OAKLEY_GROUP_GENERATOR_ONE    7
#define OAKLEY_GROUP_GENERATOR_TWO    8
#define OAKLEY_GROUP_CURVE_A          9
#define OAKLEY_GROUP_CURVE_B          10
#define OAKLEY_LIFE_TYPE              11
#define OAKLEY_LIFE_DURATION          12
#define OAKLEY_PRF                    13
#define OAKLEY_KEY_LENGTH             14

/* Oakley Lifetime Type attribute */

#define OAKLEY_LIFE_SECONDS   1
#define OAKLEY_LIFE_KILOBYTES 2

#define OAKLEY_ISAKMP_SA_LIFETIME 3600    /* One hour */

/* Oakley PRF attribute */

#define OAKLEY_PRF_3DES_CBC_MAC   1

/* HMAC */

#define HMAC_IPAD            0x36
#define HMAC_OPAD            0x5C
#define HMAC_BUFSIZE         64

/* Oakley Encryption Algorithm attribute */

#define OAKLEY_DES_CBC          1
#define OAKLEY_IDEA_CBC         2
#define OAKLEY_BLOWFISH_CBC     3
#define OAKLEY_RC5_R12_B64_CBC  4
#define OAKLEY_3DES_CBC         5
#define OAKLEY_CAST_CBC         6

/* Oakley Hash Algorithm attribute */

#define OAKLEY_MD5      1
#define OAKLEY_SHA      2
#define OAKLEY_TIGER    3

/* Oakley Authentication Method attribute */

#define OAKLEY_PRESHARED_KEY       1
#define OAKLEY_DSS_SIG             2
#define OAKLEY_RSA_SIG             3
#define OAKLEY_RSA_ENC             4

/* Oakley Group Description attribute */

#define OAKLEY_DEFAULT_GROUP       1
