/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DerInputStream;
import com.sun.crypto.provider.DerOutputStream;
import com.sun.crypto.provider.HexDumpEncoder;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class DESParameters
extends AlgorithmParametersSpi {
    private byte[] iv;

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOctetString(this.iv);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName("javax.crypto.spec.IvParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        byte[] byArray = ((IvParameterSpec)algorithmParameterSpec).getIV();
        if (byArray.length != 8) {
            throw new InvalidParameterSpecException("IV not 8 bytes long");
        }
        this.iv = (byte[])byArray.clone();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        if (derInputStream.available() != 0) {
            throw new IOException("IV parsing error: extra data");
        }
        if (byArray2.length != 8) {
            throw new IOException("IV not 8 bytes long");
        }
        this.iv = byArray2;
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        String string = "\n    iv:\n[";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = String.valueOf(string) + hexDumpEncoder.encodeBuffer(this.iv);
        string = String.valueOf(string) + "]\n";
        return string;
    }
}

