/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import java.util.Properties;

final class JceSecurity {
    private JceSecurity() {
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        while (!clazz.equals(clazz2)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    private static ProviderProperty getEngineClassName(String string, String string2) throws NoSuchAlgorithmException {
        ProviderProperty providerProperty;
        String string3 = JceSecurity.getStandardName(string, string2);
        if (string3 == null) {
            string3 = string;
        }
        if ((providerProperty = JceSecurity.getProviderProperty(String.valueOf(string2) + "." + string3)) == null) {
            throw new NoSuchAlgorithmException("algorithm " + string + " not available.");
        }
        return providerProperty;
    }

    private static ProviderProperty getEngineClassName(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object object;
        Provider provider;
        if (string2 == null) {
            return JceSecurity.getEngineClassName(string, string3);
        }
        String string4 = JceSecurity.getStandardName(string, string3);
        if (string4 == null) {
            string4 = string;
        }
        if ((provider = Security.getProvider(string2)) == null) {
            throw new NoSuchProviderException("no such provider: " + string2);
        }
        String string5 = String.valueOf(string3) + "." + string4;
        String string6 = ((Properties)provider).getProperty(string5);
        if (string6 == null) {
            object = ((Hashtable)provider).keys();
            while (object.hasMoreElements() && string6 == null) {
                String string7 = (String)object.nextElement();
                if (!string5.equalsIgnoreCase(string7)) continue;
                string6 = ((Properties)provider).getProperty(string7);
            }
        }
        if (string6 == null) {
            throw new NoSuchAlgorithmException("no such algorithm: " + string + " for provider " + string2);
        }
        object = new ProviderProperty();
        ((ProviderProperty)object).property = string6;
        ((ProviderProperty)object).provider = provider;
        return object;
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderProperty providerProperty = JceSecurity.getEngineClassName(string, string3, string2);
        String string4 = providerProperty.property;
        try {
            Class<?> clazz = Class.forName("javax.crypto." + string2 + "Spi");
            Class<?> clazz2 = Class.forName(string4);
            if (JceSecurity.checkSuperclass(clazz2, clazz)) {
                Object obj = clazz2.newInstance();
                return new Object[]{obj, providerProperty.provider};
            }
            throw new NoSuchAlgorithmException("class configured for " + string2 + ": " + string4 + " not a " + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("class configured for " + string2 + " (provider: " + string3 + ")" + " cannot be found.\n" + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + " (provider: " + string3 + ") cannot be instantiated.\n" + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + " (provider: " + string3 + ") cannot be accessed.\n" + illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + " (provider: " + string3 + ") cannot be accessed.\n" + securityException.getMessage());
        }
    }

    private static ProviderProperty getProviderProperty(String string) {
        String string2 = null;
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            Object object;
            Provider provider = providerArray[n];
            String string3 = ((Properties)provider).getProperty(string);
            if (string3 == null) {
                object = ((Hashtable)provider).keys();
                while (object.hasMoreElements() && string3 == null) {
                    string2 = (String)object.nextElement();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    string3 = ((Properties)provider).getProperty(string2);
                }
            }
            if (string3 != null) {
                object = new ProviderProperty();
                ((ProviderProperty)object).property = string3;
                ((ProviderProperty)object).provider = provider;
                return object;
            }
            ++n;
        }
        return null;
    }

    private static String getStandardName(String string, String string2) {
        ProviderProperty providerProperty = JceSecurity.getProviderProperty("Alg.Alias." + string2 + "." + string);
        if (providerProperty != null) {
            return providerProperty.property;
        }
        return null;
    }

    private static class ProviderProperty {
        String property;
        Provider provider;

        ProviderProperty() {
        }
    }
}

