/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;

public class ElectronicCodeBook
extends SymmetricCipher {
    private SymmetricCipher embeddedCipher = null;
    private int blockSize = -1;

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        int n4 = n + n2;
        while (n < n4) {
            this.embeddedCipher.decrypt(byArray, n, this.blockSize, byArray2, n3);
            n3 += this.blockSize;
            n += this.blockSize;
        }
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        int n4 = n + n2;
        while (n < n4) {
            this.embeddedCipher.encrypt(byArray, n, this.blockSize, byArray2, n3);
            n += this.blockSize;
            n3 += this.blockSize;
        }
    }

    public int getBlockSize() {
        if (this.embeddedCipher == null) {
            return -1;
        }
        return this.embeddedCipher.getBlockSize();
    }

    public void init(Key key) throws InvalidKeyException {
        this.embeddedCipher.init(key);
    }

    public void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(key);
    }

    public void setEmbeddedCipher(SymmetricCipher symmetricCipher) throws NoSuchAlgorithmException {
        if (symmetricCipher == null || (this.blockSize = symmetricCipher.getBlockSize()) <= 0) {
            throw new NoSuchAlgorithmException("Incompatible algorithm type and mode");
        }
        this.embeddedCipher = symmetricCipher;
    }
}

