/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.DHKeyExchange;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.PreMasterSecret;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

public final class ServerHandshaker
extends Handshaker {
    public boolean a;
    public boolean b = false;
    public X509Certificate[] c;
    public PrivateKey d;
    public PrivateKey e;
    public RSAPublicKey f;
    public DHKeyExchange g;

    public ServerHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, boolean bl2) throws NoSuchAlgorithmException {
        super(sSLSocketImpl, sSLContextImpl, bl2);
        this.a = bl2;
    }

    public boolean canExchange(int n2, boolean bl2) {
        X509KeyManager x509KeyManager = this.sslContext.c();
        if (n2 == 1 || n2 == 2 || n2 == 5) {
            String string = x509KeyManager.chooseServerAlias("RSA", null);
            if (string == null) {
                return false;
            }
            this.d = x509KeyManager.getPrivateKey(string);
            if (this.d == null) {
                return false;
            }
            this.c = x509KeyManager.getCertificateChain(string);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)this.c[0].getPublicKey();
            if (n2 == 2 && rSAPublicKey.getModulus().bitLength() > 512 && !this.b(bl2)) {
                return false;
            }
            if (n2 == 5) {
                this.a(bl2);
            }
            return this.d != null && this.d instanceof RSAPrivateKey;
        }
        if (n2 == 6) {
            String string = x509KeyManager.chooseServerAlias("DSA", null);
            if (string == null) {
                return false;
            }
            this.d = x509KeyManager.getPrivateKey(string);
            if (this.d == null) {
                return false;
            }
            this.c = x509KeyManager.getCertificateChain(string);
            this.a(bl2);
            return this.d != null;
        }
        if (n2 == 7) {
            this.a(bl2);
            return true;
        }
        return false;
    }

    public boolean canUseCipherSuite(String string) {
        if (string.startsWith("SSL_RSA_")) {
            return this.canExchange(1, false);
        }
        if (string.startsWith("SSL_DH_anon_")) {
            return this.canExchange(7, false);
        }
        if (string.startsWith("SSL_DHE_DSS_")) {
            return this.canExchange(6, false);
        }
        return false;
    }

    private boolean a(HandshakeMessage.ClientHello clientHello, byte[] byArray) {
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < clientHello.e.length) {
            if (byArray[0] == clientHello.e[n2] && byArray[1] == clientHello.e[n2 + 1]) break;
            n2 += 2;
        }
        if (n2 < clientHello.e.length) {
            bl2 = this.maybeSetCipherSuite(byArray[0], byArray[1]);
        }
        return bl2;
    }

    private void a(HandshakeMessage.ClientHello clientHello) throws IOException {
        int n2 = 0;
        while (n2 < clientHello.e.length) {
            if (this.maybeSetCipherSuite(clientHello.e[n2], clientHello.e[n2 + 1]) && (!this.a || this.key_exchange_algorithm != 7)) break;
            n2 += 2;
        }
        if (n2 >= clientHello.e.length) {
            this.conn.a((byte)40, "no cipher suites in common");
        }
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509TrustManager x509TrustManager;
        X509Certificate[] x509CertificateArray = certificateMsg.getCertificateChain();
        if (x509CertificateArray.length == 0) {
            this.conn.a((byte)42, "null cert chain");
        }
        if ((x509TrustManager = this.sslContext.d()).isClientTrusted(x509CertificateArray)) {
            this.session.a(x509CertificateArray);
        } else {
            this.conn.a((byte)46, "untrusted client cert chain");
        }
    }

    private void a(HandshakeMessage.CertificateVerify certificateVerify) throws IOException {
        boolean bl2 = false;
        try {
            PublicKey publicKey = this.session.getPeerCertificateChain()[0].getPublicKey();
            try {
                bl2 = certificateVerify.a(this.v_minor, publicKey, (MessageDigest)this.md5[0].clone(), (MessageDigest)this.sha1[0].clone(), this.session.c());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                bl2 = certificateVerify.a(this.v_minor, publicKey, this.md5[2], this.sha1[2], this.session.c());
                this.md5[2] = null;
                this.sha1[2] = null;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.conn.a((byte)43, "client cert type is unsupported");
        }
        catch (SignatureException signatureException) {
        }
        catch (InvalidKeyException invalidKeyException) {}
        if (!bl2) {
            this.conn.a((byte)42, "client cert didn't verify");
        }
    }

    private void a(HandshakeMessage.Finished finished) throws IOException {
        boolean bl2 = false;
        try {
            bl2 = this.v_minor == 0 ? finished.verify((MessageDigest)this.md5[0].clone(), (MessageDigest)this.sha1[0].clone(), HandshakeMessage.Finished.c, this.session.c()) : finished.verify((MessageDigest)this.md5[0].clone(), (MessageDigest)this.sha1[0].clone(), "client finished", this.session.c());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl2 = this.v_minor == 0 ? finished.verify(this.md5[1], this.sha1[1], HandshakeMessage.Finished.c, this.session.c()) : finished.verify(this.md5[1], this.sha1[1], "client finished", this.session.c());
            this.md5[1] = null;
            this.sha1[1] = null;
        }
        if (!bl2) {
            this.conn.a((byte)40, "client 'finished' message doesn't verify");
        }
        if (!this.resumingSession) {
            this.input.digestNow();
            this.c(false);
        }
        if (this.session.e()) {
            this.sslContext.b().a(this.session);
        }
    }

    private void b(HandshakeMessage.ClientHello clientHello) throws IOException {
        Object object;
        Object object2;
        this.input.digestNow();
        HandshakeMessage.ServerHello serverHello = new HandshakeMessage.ServerHello();
        if (clientHello.a != 3) {
            throw new SSLProtocolException("version mismatch, client is v" + clientHello.a + "." + clientHello.b);
        }
        serverHello.a = (byte)3;
        this.v_major = clientHello.a;
        serverHello.b = clientHello.b > 1 ? (byte)1 : clientHello.b;
        this.v_minor = serverHello.b;
        this.conn.a(this.v_major, this.v_minor);
        this.output.r.a(this.v_major, this.v_minor);
        this.clnt_random = clientHello.c;
        serverHello.c = this.svr_random = new e(CipherSpec.s);
        if (clientHello.d.b() != 0) {
            if (this.session != null && !this.b && !clientHello.d.equals(this.session.d())) {
                throw new SSLException("Client cannot change existing session");
            }
            this.session = null;
            object2 = this.sslContext.b().a(clientHello.d.a());
            if (object2 != null) {
                object = ((SSLSessionImpl)object2).a().getCipherSuite();
                this.resumingSession = ((SSLSessionImpl)object2).e();
                if (this.resumingSession) {
                    this.resumingSession = this.a(clientHello, (byte[])object);
                }
                if (this.resumingSession && this.a) {
                    try {
                        ((SSLSessionImpl)object2).getPeerCertificateChain();
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        this.resumingSession = false;
                    }
                }
                if (this.resumingSession) {
                    this.session = object2;
                }
            }
        } else {
            if (this.session != null && !this.b) {
                throw new SSLException("Client cannot change existing session");
            }
            this.session = null;
        }
        if (this.session == null) {
            if (!this.enableNewSession) {
                throw new SSLException("Client did not resume a session");
            }
            this.session = new SSLSessionImpl(this, this.conn.e(), this.conn.getPort());
            this.a(clientHello);
        }
        serverHello.e = this.session.a().getCipherSuite();
        serverHello.d = this.session.d();
        serverHello.f = this.session.b();
        serverHello.write(this.output);
        if (this.resumingSession) {
            try {
                this.calculateConnectionKeys(this.session.c());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLException("Missing algorithm: " + noSuchAlgorithmException.getMessage());
            }
            this.c(true);
            return;
        }
        if (this.key_exchange_algorithm != 7) {
            if (this.c == null) {
                throw new SSLException("internal error, no certs!");
            }
            object2 = new HandshakeMessage.CertificateMsg(this.c);
            ((HandshakeMessage)object2).write(this.output);
        }
        boolean bl2 = false;
        if (this.c == null) {
            bl2 = true;
        } else {
            switch (this.key_exchange_algorithm) {
                case 1: 
                case 2: {
                    if (this.key_exchange_algorithm != 2 || ((RSAPrivateKey)this.d).getModulus().bitLength() <= 512) break;
                    bl2 = true;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new SSLException("unsupported server key exchange " + this.key_exchange_algorithm);
                }
                case 3: 
                case 4: 
            }
        }
        if (bl2) {
            switch (this.key_exchange_algorithm) {
                case 1: 
                case 2: {
                    try {
                        if (this.c == null) {
                            throw new SSLException("Anonymous RSA not supported");
                        }
                        object = new HandshakeMessage.RSA_ServerKeyExchange(this.f, this.d, this.clnt_random, this.svr_random);
                        this.d = this.e;
                        break;
                    }
                    catch (SignatureException signatureException) {
                        throw new SSLException("Internal error, " + signatureException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SSLException("Algorithm missing, " + noSuchAlgorithmException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new SSLException("Bad RSA key, " + invalidKeyException);
                    }
                }
                case 7: {
                    object = new HandshakeMessage.DH_ServerKeyExchange(this.g);
                    break;
                }
                case 5: 
                case 6: {
                    try {
                        object = new HandshakeMessage.DH_ServerKeyExchange(this.g, this.d, this.clnt_random.a, this.svr_random.a);
                        break;
                    }
                    catch (SignatureException signatureException) {
                        throw new SSLException("Internal error, " + signatureException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new SSLException("Bad RSA or DSS key, " + invalidKeyException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SSLException("Algorithm missing, " + noSuchAlgorithmException);
                    }
                }
                default: {
                    throw new SSLException("unsupported server key exchange " + this.key_exchange_algorithm);
                }
            }
            ((HandshakeMessage)object).write(this.output);
        }
        if (this.a) {
            X509Certificate[] x509CertificateArray = this.sslContext.d().getAcceptedIssuers();
            object = new HandshakeMessage.CertificateRequest(x509CertificateArray, this.key_exchange_algorithm);
            ((HandshakeMessage)object).write(this.output);
        }
        object = new HandshakeMessage.ServerHelloDone();
        ((HandshakeMessage)object).write(this.output);
        this.output.flush();
    }

    private byte[] a(ClientDiffieHellmanPublic clientDiffieHellmanPublic) throws IOException, NoSuchAlgorithmException {
        return this.g.getAgreedSecret(clientDiffieHellmanPublic.getClientPublicKey());
    }

    private byte[] a(PreMasterSecret preMasterSecret) throws IOException, NoSuchAlgorithmException {
        if (preMasterSecret.a != this.v_major || preMasterSecret.b != this.v_minor) {
            throw new SSLProtocolException("Incorrect RSA Key Exchange");
        }
        return preMasterSecret.c;
    }

    private void a(boolean bl2) {
        if (!bl2) {
            this.g = new DHKeyExchange();
            this.g.generateKeyPair(CipherSpec.s, 768);
        } else {
            this.g = new DHKeyExchange(DHKeyExchange.export512Modulus, DHKeyExchange.export512Base);
            this.g.generateKeyPair(CipherSpec.s, 512);
        }
    }

    private boolean b(boolean bl2) {
        Object var2_2 = null;
        try {
            int n2 = !bl2 ? 1024 : 512;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(n2, CipherSpec.s);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            this.f = (RSAPublicKey)keyPair.getPublic();
            this.e = keyPair.getPrivate();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public HandshakeMessage getKickstartMessage() {
        return new HandshakeMessage.HelloRequest();
    }

    public void a(byte by2) throws SSLProtocolException {
        throw new SSLProtocolException("handshake alert not dealt with:  " + by2);
    }

    public void processMessage(byte by2, int n2) throws IOException, NoSuchAlgorithmException {
        if (this.state > by2 && this.state != 16 && by2 != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + this.state + ", type = " + by2);
        }
        switch (by2) {
            case 1: {
                this.b(new HandshakeMessage.ClientHello(this.input));
                break;
            }
            case 11: {
                if (!this.a) {
                    this.conn.a((byte)10, "client sent unsolicited cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(this.input));
                break;
            }
            case 16: {
                byte[] byArray;
                switch (this.key_exchange_algorithm) {
                    case 1: 
                    case 2: {
                        byArray = this.a(new PreMasterSecret(this.v_major, this.v_minor, CipherSpec.s, this.input, n2, this.d));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        byArray = this.a(new ClientDiffieHellmanPublic(this.input));
                        break;
                    }
                    default: {
                        throw new SSLProtocolException("unsupported key exchange algorithm = " + this.key_exchange_algorithm);
                    }
                }
                this.calculateKeys(byArray);
                int n3 = 0;
                while (n3 < byArray.length) {
                    byArray[n3] = 0;
                    ++n3;
                }
                break;
            }
            case 15: {
                this.a(new HandshakeMessage.CertificateVerify(this.input));
                break;
            }
            case 20: {
                this.a(new HandshakeMessage.Finished(this.v_major, this.v_minor, this.input));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + by2);
            }
        }
        if (this.state < by2 && by2 != 15) {
            this.state = by2;
        }
    }

    private void c(boolean bl2) throws IOException {
        HandshakeMessage.Finished finished;
        block3: {
            this.output.flush();
            try {
                finished = this.v_minor == 0 ? new HandshakeMessage.Finished(this.v_major, this.v_minor, (MessageDigest)this.md5[0].clone(), (MessageDigest)this.sha1[0].clone(), HandshakeMessage.Finished.d, this.session.c()) : new HandshakeMessage.Finished(this.v_major, this.v_minor, (MessageDigest)this.md5[0].clone(), (MessageDigest)this.sha1[0].clone(), "server finished", this.session.c());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                finished = this.v_minor == 0 ? new HandshakeMessage.Finished(this.v_major, this.v_minor, this.md5[0], this.sha1[0], HandshakeMessage.Finished.d, this.session.c()) : new HandshakeMessage.Finished(this.v_major, this.v_minor, this.md5[0], this.sha1[0], "server finished", this.session.c());
                if (bl2 && this.resumingSession) break block3;
                this.md5[0] = null;
                this.sha1[0] = null;
            }
        }
        this.sendChangeCipherSpec(finished);
        if (!bl2 || !this.resumingSession) {
            this.state = 20;
        }
    }
}

