/**
   SSLServer.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Fri Jun 18 09:15:27 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: SSLServer.java,v 1.4 1999/06/22 18:19:45 ekr Exp $

*/


package COM.claymoresystems.ptls.demo;
import COM.claymoresystems.ptls.*;
import COM.claymoresystems.cert.*;
import COM.claymoresystems.sslg.*;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.security.SecureRandom;
import java.io.*;
import java.util.Vector;

/**
   This client emulates a simple web server, and serves up a static file.
*/
class SSLServer {
     private static int port=4433;
     private static String keyfile="server.pem";
     private static String rootfile="root.pem";
     private static String password="password";
     private static LongOpt Longopts[]=new LongOpt[7];
     private static int iterate=0;
     private static boolean clientauth=false;
     private static boolean renegotiate=false;     
     
     static {
       int i=0;
       
       Longopts[i++]=new LongOpt("port",LongOpt.REQUIRED_ARGUMENT, null, 'p');
       Longopts[i++]=new LongOpt("keyfile",LongOpt.REQUIRED_ARGUMENT, null, 'k');
       Longopts[i++]=new LongOpt("rootfile",LongOpt.REQUIRED_ARGUMENT, null, 'r');
       Longopts[i++]=new LongOpt("clientauth",LongOpt.NO_ARGUMENT, null, 'c');
       Longopts[i++]=new LongOpt("password",LongOpt.REQUIRED_ARGUMENT, null, 'P');
       Longopts[i++]=new LongOpt("renegotiate",LongOpt.NO_ARGUMENT, null, 'C');
       Longopts[i++]=new LongOpt("debug",LongOpt.REQUIRED_ARGUMENT, null, 'd');
     }
     
     private static void webServe(SSLSocket s)
       throws IOException {
       
       InputStreamReader ir=new InputStreamReader(s.getInputStream());
       BufferedReader br=new BufferedReader(ir);
	 
       OutputStreamWriter or=new OutputStreamWriter(s.getOutputStream());

       BufferedWriter bw=new BufferedWriter(or);

       String str;
       do {
	 str=br.readLine();

	 if(str==null)
	   return;

	 str.trim();
	   
//	 System.out.println(str + str.length());
       } while(str.length()>0);

       bw.write("HTTP/1.0 200 OK\r\n");
       bw.write("Server: PureTLS Demo Server\r\n");
       bw.write("\r\n");
       bw.write("Success!\r\n");
       bw.flush();
       
       s.close();
     }       

     private static void usage() {
       System.out.println("SSLClient usage ");
       System.out.println("SSLClient [args]");
       System.out.println("  --port, -h: the port to connect to (default 4433)");
       System.out.println("  --keyfile, -k: the keyfile to use (default dsakeys.pem)");
       System.out.println("  --rootfile, -r: the rootfile to use (default root.pem)");
       System.out.println("  --password, -P: the password to use (default password)");
       System.out.println("  --clientauth, -c: require client authentication");
       System.out.println("  --renegotiate, -C: negotiate w/o client auth and then");
       System.out.println("    renegotiate with");
       System.out.println("  --debug, -d: set the debugging flags");       
     }
       
     public static void main(String[] args){
       int c;
       
       Getopt g=new Getopt("SSLServer", args, "h:p:k:r:RcCd:",Longopts);

       while((c=g.getopt())!=-1)
	 switch(c){
	   case 'p':
	     port=Integer.parseInt(g.getOptarg());
	     break;
 	   case 'c':
	     clientauth=true;
	     break;
	   case 'C':
	     clientauth=false;
	     renegotiate=true;
	     break;
	   case 'k':
	     keyfile=new String(g.getOptarg());
	     break;
	   case 'r':
	     rootfile=new String(g.getOptarg());
	     break;
	   case 'P':
	     password=new String(g.getOptarg());
	     break;
	   case 'd':
	     SSLDebug.setDebug(Integer.parseInt(g.getOptarg()));
	     break;
	   default:
	     usage();
	     return;
	 }

       SSLContext ctx=new SSLContext();

       try {
	 ctx.loadRootCertificates(rootfile);
	 ctx.loadEAYKeyFile(keyfile,password);
	 SSLServerSocket sock=new SSLServerSocket(ctx,port);
	 SSLPolicyInt policy=new SSLPolicyInt();
	 policy.requireClientAuth(clientauth);
	 ctx.setPolicy(policy);
	 
	 for(;;){
	   SSLSocket s=(SSLSocket)sock.accept();
	   System.out.println("Accepted connection");

	   if(renegotiate){
	     policy=new SSLPolicyInt();
	     policy.requireClientAuth(true);
	     s.renegotiate(policy);
	   }
	   
	   if(policy.requireClientAuthP()){
	     System.out.println("Cert chain");
	     Vector cc=s.getCertificateChain();
	     
	     for(int i=0;i<cc.size();i++){
	       X509Cert cert=(X509Cert)cc.elementAt(i);
	       
	       System.out.println("Issuer "+cert.getIssuerName().getNameString());
	       System.out.println("Subject "+cert.getSubjectName().getNameString());
	       System.out.println("Serial "+cert.getSerial());
	       System.out.println("Validity "+cert.getValidityNotBefore() +"-"+
		 cert.getValidityNotAfter());
	     }
	   }

	   webServe(s);
	 }
       } catch (Exception e){
	 e.printStackTrace();
       }


     }

}
