/* Copyright Per Bothner 1987. Read the file Q-INFO */
/* structs to help in reading and writing b.out.h files */

struct vaxsym {			/* reflects what the vax compiler generates */
	char stype;
	char slength;
	short padding;
	long svalue;
	};

struct vaxreloc {
	unsigned dummy1:3;
	unsigned rdisp:1;
	unsigned rsize:2;
	unsigned rsegment:2;
	char dummy2;
	short rsymbol;
	long rpos;
	};

struct ExtSymbol
  {
    struct ExtSymbol *next;
    short symNum;
    struct vaxsym s;
    /* followed by the characters of the symbol */
  };

extern struct ExtSymbol *AddSymbol();

#define RFORGET 4	/* no longer needed; don't write out */
struct Relocation
  {
    struct Relocation *next;
    char rsegment;		/* RTEXT, RDATA, RBSS, REXTERN or RFORGET */
    char rsize;			/* RBYTE, RWORD, or RLONG */
    char rdisp;			/* 1 => a displacement */
    struct ExtSymbol *rsymbol;	/* for external relocations */
    long rpos;			/* position of relocation in segment */
  };
