//
// linteger.inl
//
// Leonard Janke
// August 1996

inline LInteger LInteger::Negative(const LInteger& x)
{
  if ( x._sign==0 && x._size==0 && *x._magnitude==0 )
    return x;

  return LInteger(x._magnitude,x._size,x._sign^1);
}

inline LInteger LInteger::AbsoluteValue(const LInteger& x)
{
  if ( x._sign==0 )
    return x;

  return LInteger(x._magnitude,x._size,x._sign^1);
}

inline int LInteger::sign() const 
{ 
  return _sign; 
}

inline int LInteger::size() const 
{ 
  return _size; 
}

inline void LInteger::setSign(const int newSign)  
{ 
   _sign=newSign; 
}

inline void LInteger::setSize(const int newSize) 
{ 
  _size=newSize; 
}

inline unsigned int* LInteger::magnitude() const 
{ 
  return _magnitude; 
}

inline int operator!(const LInteger& a)
{
  return  !a._sign && a._size==1 && *a._magnitude==0 ;
}

inline int operator&&(const LInteger& a,const int b)
{
  return a!=0 && b;
}

inline int operator&&(const int a,const LInteger& b)
{
  return a && b!=0;
}

inline int operator||(const LInteger& a,const int b)
{
  return a!=0 || b;
}

inline int operator||(const int a,const LInteger& b)
{
  return a || b!=0;
}

inline LInteger operator-(const LInteger& x)
{
  return LInteger::Negative(x);
}

inline LInteger operator+(const LInteger& x)
{
  return LInteger(x);
}

inline LInteger& LInteger::operator^=(const LInteger& a)
{
  *this=*this^a; 
  return *this;
}

inline LInteger& LInteger::operator|=(const LInteger& a)
{
  *this=*this|a; 
  return *this;
}

inline LInteger& LInteger::operator&=(const LInteger& a)
{
  *this=*this&a; 
  return *this;
}

inline LInteger& LInteger::operator+=(const LInteger& a)
{
  *this=*this+a; 
  return *this;
}

inline LInteger operator-(const LInteger& a, const LInteger& b) 
{
  return a+(-b);
}

inline LInteger& LInteger::operator-=(const LInteger& a)
{
  *this=*this-a; 
  return *this;
}

inline LInteger& LInteger::operator*=(const LInteger& a)
{
  *this=*this *a; 
  return *this;
}

inline LInteger& LInteger::operator/=(const LInteger& a)
{
  *this=*this/a; 
  return *this;
}

inline LInteger& LInteger::operator%=(const LInteger& a)
{
  *this=*this%a; 
  return *this;
}

inline LInteger& LInteger::operator>>=(const int distance)
{
  *this=*this>>distance;
  return *this;
}

inline LInteger& LInteger::operator<<=(const int distance)
{
  *this=*this<<distance;
  return *this;
}

inline LInteger& LInteger::operator++(int) 
{ 
  *this+=1; 
  return *this; 
}

inline LInteger& LInteger::operator++() 
{ 
  *this+=1; 
  return *this; 
}

inline LInteger& LInteger::operator--(int) 
{ 
  *this-=1; 
  return *this; 
}

inline LInteger& LInteger::operator--() 
{ 
  *this-=1; 
  return *this; 
}

inline int operator<(const LInteger& a, const LInteger& b)
{
  if ( a._sign && ! b._sign ) // a<0 && b>=0
      return 1;
  else if ( ! a._sign && b._sign ) // a>=0 & b<0
    return 0;

  // same sign

  if ( a._sign ) // a,b <0
    return LInteger::CompareMagnitudes(a,b) >0; 
  else         //a,b >0
    return LInteger::CompareMagnitudes(a,b) < 0; 
}
 	
inline int operator>(const LInteger& a, const LInteger& b)
{
  if ( a._sign && !b._sign ) // a<0 && b>=0
    return 0;
  else if ( !a._sign && b._sign ) // a>=0 & b<0
    return 1;
    
  // same sign

  if ( a._sign ) // a,b<0
    return LInteger::CompareMagnitudes(a,b) < 0;  
  else // a,b >0
    return LInteger::CompareMagnitudes(a,b) > 0;  
}

inline int operator==(const LInteger& a, const LInteger& b)
{ 
  return (a._sign == b._sign) && !LInteger::CompareMagnitudes(a,b); 
}

inline int operator!=(const LInteger& a, const LInteger& b)
{ 
  return (a._sign != b._sign) || LInteger::CompareMagnitudes(a,b); 
}

inline int operator<=(const LInteger& a, const LInteger& b)
{
  return  a<b || a==b ;
}

inline int operator>=(const LInteger& a, const LInteger& b)
{
  return  a>b || a==b ;
}

inline LInteger::operator int()
{
  // return the (-1)**_sign * LSW
  const unsigned int mask=~0^(1<<(LMisc::bitsPerInt-1));

  if ( _sign )
    return -1*int((*(this->_magnitude+this->_size-1))&mask);

  return int((*(this->_magnitude+this->_size-1))&mask);
}

inline int LInteger::compressable() const 
{ 
  return _size>1 && *_magnitude==0; 
} 
