/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

decode_t61s(et61s, dt61s, rlength)
struct bbuf *et61s;
char **dt61s;
int *rlength;
{
    struct bbuf *bb = NULLBB;
    int r;
	
    if (et61s == NULLBB) {
	return(NOTOK);
    }

    if (dt61s == NULLVP) {
	return(NOTOK);
    }
    FREE(*dt61s)

    if (rlength == (int *)0) {
	return(NOTOK);
    }

    if (et61s->length < 2) {
	return(ASN1_ERR01);
    }
    r = decode_str(et61s, (CLASS_UNIV|FORM_PRIM|DEFN_T61S), &bb, rlength);
    if (r == OK)
        r = t612str(bb->data, bb->length, dt61s);

    FREE_BBUF(bb);

    return(r);
}
