/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <ctype.h>
#include <stdio.h>
#include "general.h"
#include "asn1.h"

#define	YEAR(y)		((y) >= 100 ? (y) : (y) + 1900)

long	get_usec ();

UTC	str2utct (cp, len)
char  *cp;
int	len;
{
    int     year, hours, mins;
    int    zone;
    static UTCtime  ut;
    UTC    u = &ut;

    BZERO(u, sizeof *u);

    if (sscanf (cp, "%2d%2d%2d%2d%2d", &year, &u -> ut_mon,
		&u -> ut_mday, &u -> ut_hour, &u -> ut_min) != 5)
	return NULLUTC;
    cp += 10, len -= 10;
    u -> ut_year = YEAR (year);

    if (len > 0 && isdigit (*cp)) {
	if (sscanf (cp, "%2d", &u -> ut_sec) != 1)
	    return NULLUTC;
	u -> ut_flags |= UT_SEC;
	cp += 2, len -= 2;
    }

    if (len > 0) {
	switch (*cp) {
	    case 'Z': 
		cp++, len--;
		break;

	    case '+': 
	    case '-': 
		if (sscanf (cp + 1, "%2d%2d", &hours, &mins) != 2)
		    return NULLUTC;
		zone = hours * 60 + mins;
		u -> ut_zone = *cp == '+' ? zone : -zone;
		cp += 5, len -= 5;
		break;

	    default: 
		return NULLUTC;
	}
	u -> ut_flags |= UT_ZONE;
    }
    if (len != 0)
	return NULLUTC;

    return u;
}
