/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"

#include <stdio.h>

#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "util.h"

struct bbuf *canoncb(inputcb)
struct bbuf *(*inputcb)();
{
    struct bbuf *inbuf, *outbuf;
    int i;
    char lastch;

    if (inputcb == NULL_INCB)
	return NULLBB;
  
    if ((inbuf = inputcb()) == NULLBB)
	return NULLBB;

    outbuf = alloc_bbuf();

    if (inbuf->length > 0)
	outbuf->data = alloc_uchar(2 * inbuf->length);

    lastch = ' ';
    outbuf->length = 0;

    for (i = 0; i < inbuf->length; i++) {
	if (inbuf->data[i] == '\n' && lastch != '\r')
	    outbuf->data[outbuf->length++] = '\r';
	outbuf->data[outbuf->length++] = inbuf->data[i];
	lastch = inbuf->data[i];
    }

    FREE_BBUF(inbuf);
    return(outbuf);
}
