/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"

#include <stdio.h>

#include "general.h"

#include "bbuf.h"
#include "util.h"

struct bbuf *cbfdread(fd)
int fd;
{
    struct bbuf *buf = NULLBB;

    buf = alloc_bbuf();
    buf->data = alloc_uchar(BUFSIZ);
    if ((buf->length = read(fd, (char *)buf->data, BUFSIZ)) == -1) {
	FREE_BBUF(buf);
	return(NULLBB);
    }

    return (buf);
}


struct bbuf *cbfdneread(fd)  /* Just like cbfdread(), except no echo */
int fd;
{
    struct bbuf *buf = NULLBB;
    int was_echo;

    if ((was_echo = ttyecho(fd, 0)) != -1) {
        buf = cbfdread(fd);
	(void) ttyecho(fd, was_echo);
    }
    return(buf);
}


int cbfdwrite(fd, buf)
int fd;
struct bbuf *buf;
{
    if (buf == NULLBB || buf->data == NULLUCP)
	return(0);

    if (buf->length == 0)
	return(0);

    if (write(fd, (char *)buf->data, buf->length) != -1)
	return(0);

    return(1);
}
