/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "new.h"
#include "util.h"

static void _get_cert_chain();
static void _get_dn_certs();

get_cert_chain(user, certs)
char **user;			/* user record with certificate */
struct bbuf **certs;
{
    int ret = NOTOK;
    char **tv;
    struct bbuf ecert;

    if (certs == (struct bbuf **)0)
	return EINVAL;
    FREE_BBUFS(*certs);

    if (user == NULLVP)
	return EINVAL;

    if ((tv = tag_user(user, "certificate")) == NULLVP)
	return NOTOK;		/* used to be ENOCERT */

    ecert.length = strlen(*(tv+1));
    ecert.data = (unsigned char *)*(tv+1);

    if ((ret = bdecode(&ecert, certs)) != OK)
	goto cleanup;

    _get_cert_chain(*certs);

    ret = (*certs == NULLBB) ? NOTOK : OK; /* NOTOK used to be ENOCERT */

 cleanup:

    FREE_BBUF(*certs);

    return(ret);
}

static void _get_cert_chain(cert)
struct bbuf *cert;
{
    struct bbuf  	*icert= NULLBB, *icerts= NULLBB,
			*tcert;
    struct bbuf		*idn= NULLBB;
    struct algid	*ialg= NULL_ALGID, *salg= NULL_ALGID;

    if (cert == NULLBB || (cert->status & BSLFSGN))
	return;

    /* Otherwise recursively get the issuer cert */
    if (issuer_cert(&cert, &idn, READ) != OK)
        goto cleanup;
    if (sig_alg_cert(&cert, &salg, INNER, READ) != OK)
        goto cleanup;

    _get_dn_certs(idn, &icerts);

    /* Only one cert per algid per dname */
    for (tcert = icerts; tcert != NULLBB; tcert = tcert->next) {
        if (sig_alg_cert(&tcert, &ialg, INNER, READ) != OK)
            continue;
	if (!algidcmp(ialg, salg)) {
	    icert = dup_bbuf(tcert);
	    break;
	}
    }

    /* Put validated issuer cert at the end of the list */
    if (icert != NULLBB) {
#ifdef notdef
        if (l_validate_cert(icert) != OK)
	    FREE_BBUF(icert);
        else
#endif notdef
	{
            cert->next = icert;
            icert->prev = cert;
            FREE_BBUFS(icert->next);
	}
    }
    FREE_ALGID(ialg);
    FREE_ALGID(salg);
    FREE_BBUF(idn);
    FREE_BBUFS(icerts);
    
    _get_cert_chain(icert);

 cleanup:

    FREE_ALGID(ialg);
    FREE_ALGID(salg);
    FREE_BBUF(idn);
    FREE_BBUFS(icerts);

    return;
}

static void _get_dn_certs(dn, certs)
struct bbuf  *dn;		/* ASN.1 encoded distinguished name */
struct bbuf **certs;		/* ASN.1 encoded certificates */
{
    struct bbuf  *edn = NULLBB;
    struct bbuf   ebuf;
    struct bbuf  *tbuf = NULLBB;
    struct bbuf  *lbuf = NULLBB;
    char        **user = NULLVP;
    char        **cert = NULLVP;

    FREE_BBUFS(*certs);

    if (bencode(dn, &edn) != OK)
	return;

    rewind_indexfile();
    while ((user = get_tv_user("subject-name", edn->data)) != NULLVP) {
	if ((cert = tag_user(user, "certificate")) == NULLVP)
	    continue;

	ebuf.length = strlen(*(cert+1));
	ebuf.data = (unsigned char *)*(cert+1);
	if (bdecode(&ebuf, tbuf) != OK)
	    continue;

	if (lbuf == NULLBB)
	    *certs = lbuf = tbuf;
	else {
	    lbuf -> next = tbuf;
	    lbuf = tbuf;
	}
	tbuf = NULLBB;
    }

    FREE_AV(user);

    FREE_BBUF(edn);
    FREE_BBUF(tbuf);

    return;
}
